"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
describe('Parallel State', () => {
    test('State Machine With Parallel State', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parallel = new stepfunctions.Parallel(stack, 'Parallel State');
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 1'));
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 2'));
        // THEN
        expect(render(parallel)).toStrictEqual({
            StartAt: 'Parallel State',
            States: {
                'Parallel State': {
                    Type: 'Parallel',
                    End: true,
                    Branches: [
                        { StartAt: 'Branch 1', States: { 'Branch 1': { Type: 'Pass', End: true } } },
                        { StartAt: 'Branch 2', States: { 'Branch 2': { Type: 'Pass', End: true } } },
                    ],
                },
            },
        });
    });
});
function render(sm) {
    return new cdk.Stack().resolve(new stepfunctions.StateGraph(sm.startState, 'Test Graph').toGraphJson());
}
//# sourceMappingURL=data:application/json;base64,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