"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pass = exports.Result = void 0;
const chain_1 = require("../chain");
const fields_1 = require("../fields");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * The result of a Pass operation
 */
class Result {
    /**
     *
     * @param value result of the Pass operation
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * The result of the operation is a string
     */
    static fromString(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is a number
     */
    static fromNumber(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is a boolean
     */
    static fromBoolean(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is an object
     */
    static fromObject(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is an array
     */
    static fromArray(value) {
        return new Result(value);
    }
}
exports.Result = Result;
/**
 * Define a Pass in the state machine
 *
 * A Pass state can be used to transform the current exeuction's state.
 */
class Pass extends state_1.State {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.result = props.result;
        this.endStates = [this];
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        super.makeNext(next.startState);
        return chain_1.Chain.sequence(this, next);
    }
    /**
     * Return the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.PASS,
            Comment: this.comment,
            Result: this.result ? this.result.value : undefined,
            ResultPath: state_1.renderJsonPath(this.resultPath),
            ...this.renderInputOutput(),
            ...this.renderParameters(),
            ...this.renderNextEnd(),
        };
    }
    /**
     * Render Parameters in ASL JSON format
     */
    renderParameters() {
        return fields_1.FieldUtils.renderObject({
            Parameters: this.parameters,
        });
    }
}
exports.Pass = Pass;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFzcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBhc3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esb0NBQStCO0FBQy9CLHNDQUF1QztBQUV2QyxxREFBaUQ7QUFDakQsbUNBQStDO0FBRS9DOztHQUVHO0FBQ0gsTUFBYSxNQUFNO0lBb0NqQjs7O09BR0c7SUFDSCxZQUFzQyxLQUFVO1FBQVYsVUFBSyxHQUFMLEtBQUssQ0FBSztJQUNoRCxDQUFDO0lBeENEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUFhO1FBQ3BDLE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUFhO1FBQ3BDLE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFjO1FBQ3RDLE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzNCLENBQUM7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBWTtRQUNsQyxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzNCLENBQUM7Q0FRRjtBQTFDRCx3QkEwQ0M7QUErREQ7Ozs7R0FJRztBQUNILE1BQWEsSUFBSyxTQUFRLGFBQUs7SUFLN0IsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUFtQixFQUFFO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsU0FBUyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDMUIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLElBQWdCO1FBQzFCLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sYUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOztPQUVHO0lBQ0ksV0FBVztRQUNoQixPQUFPO1lBQ0wsSUFBSSxFQUFFLHNCQUFTLENBQUMsSUFBSTtZQUNwQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ25ELFVBQVUsRUFBRSxzQkFBYyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDM0MsR0FBRyxJQUFJLENBQUMsaUJBQWlCLEVBQUU7WUFDM0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7WUFDMUIsR0FBRyxJQUFJLENBQUMsYUFBYSxFQUFFO1NBQ3hCLENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDSyxnQkFBZ0I7UUFDdEIsT0FBTyxtQkFBVSxDQUFDLFlBQVksQ0FBQztZQUM3QixVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDNUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBM0NELG9CQTJDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7Q2hhaW59IGZyb20gJy4uL2NoYWluJztcbmltcG9ydCB7IEZpZWxkVXRpbHMgfSBmcm9tICcuLi9maWVsZHMnO1xuaW1wb3J0IHtJQ2hhaW5hYmxlLCBJTmV4dGFibGV9IGZyb20gJy4uL3R5cGVzJztcbmltcG9ydCB7IFN0YXRlVHlwZSB9IGZyb20gJy4vcHJpdmF0ZS9zdGF0ZS10eXBlJztcbmltcG9ydCB7cmVuZGVySnNvblBhdGgsIFN0YXRlIH0gZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogVGhlIHJlc3VsdCBvZiBhIFBhc3Mgb3BlcmF0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBSZXN1bHQge1xuICAvKipcbiAgICogVGhlIHJlc3VsdCBvZiB0aGUgb3BlcmF0aW9uIGlzIGEgc3RyaW5nXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21TdHJpbmcodmFsdWU6IHN0cmluZyk6IFJlc3VsdCB7XG4gICAgcmV0dXJuIG5ldyBSZXN1bHQodmFsdWUpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSByZXN1bHQgb2YgdGhlIG9wZXJhdGlvbiBpcyBhIG51bWJlclxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tTnVtYmVyKHZhbHVlOiBudW1iZXIpOiBSZXN1bHQge1xuICAgIHJldHVybiBuZXcgUmVzdWx0KHZhbHVlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgcmVzdWx0IG9mIHRoZSBvcGVyYXRpb24gaXMgYSBib29sZWFuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Cb29sZWFuKHZhbHVlOiBib29sZWFuKTogUmVzdWx0IHtcbiAgICByZXR1cm4gbmV3IFJlc3VsdCh2YWx1ZSk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIHJlc3VsdCBvZiB0aGUgb3BlcmF0aW9uIGlzIGFuIG9iamVjdFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tT2JqZWN0KHZhbHVlOiB7W2tleTogc3RyaW5nXTogYW55fSk6IFJlc3VsdCB7XG4gICAgcmV0dXJuIG5ldyBSZXN1bHQodmFsdWUpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSByZXN1bHQgb2YgdGhlIG9wZXJhdGlvbiBpcyBhbiBhcnJheVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQXJyYXkodmFsdWU6IGFueVtdKTogUmVzdWx0IHtcbiAgICByZXR1cm4gbmV3IFJlc3VsdCh2YWx1ZSk7XG4gIH1cblxuICAvKipcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIHJlc3VsdCBvZiB0aGUgUGFzcyBvcGVyYXRpb25cbiAgICovXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3RvcihwdWJsaWMgcmVhZG9ubHkgdmFsdWU6IGFueSkge1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBQYXNzIHN0YXRlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUGFzc1Byb3BzIHtcbiAgLyoqXG4gICAqIEFuIG9wdGlvbmFsIGRlc2NyaXB0aW9uIGZvciB0aGlzIHN0YXRlXG4gICAqXG4gICAqIEBkZWZhdWx0IE5vIGNvbW1lbnRcbiAgICovXG4gIHJlYWRvbmx5IGNvbW1lbnQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEpTT05QYXRoIGV4cHJlc3Npb24gdG8gc2VsZWN0IHBhcnQgb2YgdGhlIHN0YXRlIHRvIGJlIHRoZSBpbnB1dCB0byB0aGlzIHN0YXRlLlxuICAgKlxuICAgKiBNYXkgYWxzbyBiZSB0aGUgc3BlY2lhbCB2YWx1ZSBESVNDQVJELCB3aGljaCB3aWxsIGNhdXNlIHRoZSBlZmZlY3RpdmVcbiAgICogaW5wdXQgdG8gYmUgdGhlIGVtcHR5IG9iamVjdCB7fS5cbiAgICpcbiAgICogQGRlZmF1bHQgJFxuICAgKi9cbiAgcmVhZG9ubHkgaW5wdXRQYXRoPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBKU09OUGF0aCBleHByZXNzaW9uIHRvIHNlbGVjdCBwYXJ0IG9mIHRoZSBzdGF0ZSB0byBiZSB0aGUgb3V0cHV0IHRvIHRoaXMgc3RhdGUuXG4gICAqXG4gICAqIE1heSBhbHNvIGJlIHRoZSBzcGVjaWFsIHZhbHVlIERJU0NBUkQsIHdoaWNoIHdpbGwgY2F1c2UgdGhlIGVmZmVjdGl2ZVxuICAgKiBvdXRwdXQgdG8gYmUgdGhlIGVtcHR5IG9iamVjdCB7fS5cbiAgICpcbiAgICogQGRlZmF1bHQgJFxuICAgKi9cbiAgcmVhZG9ubHkgb3V0cHV0UGF0aD86IHN0cmluZztcblxuICAvKipcbiAgICogSlNPTlBhdGggZXhwcmVzc2lvbiB0byBpbmRpY2F0ZSB3aGVyZSB0byBpbmplY3QgdGhlIHN0YXRlJ3Mgb3V0cHV0XG4gICAqXG4gICAqIE1heSBhbHNvIGJlIHRoZSBzcGVjaWFsIHZhbHVlIERJU0NBUkQsIHdoaWNoIHdpbGwgY2F1c2UgdGhlIHN0YXRlJ3NcbiAgICogaW5wdXQgdG8gYmVjb21lIGl0cyBvdXRwdXQuXG4gICAqXG4gICAqIEBkZWZhdWx0ICRcbiAgICovXG4gIHJlYWRvbmx5IHJlc3VsdFBhdGg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIElmIGdpdmVuLCB0cmVhdCBhcyB0aGUgcmVzdWx0IG9mIHRoaXMgb3BlcmF0aW9uXG4gICAqXG4gICAqIENhbiBiZSB1c2VkIHRvIGluamVjdCBvciByZXBsYWNlIHRoZSBjdXJyZW50IGV4ZWN1dGlvbiBzdGF0ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgTm8gaW5qZWN0ZWQgcmVzdWx0XG4gICAqL1xuICByZWFkb25seSByZXN1bHQ/OiBSZXN1bHQ7XG5cbiAgLyoqXG4gICAqIFBhcmFtZXRlcnMgcGFzcyBhIGNvbGxlY3Rpb24gb2Yga2V5LXZhbHVlIHBhaXJzLCBlaXRoZXIgc3RhdGljIHZhbHVlcyBvciBKU09OUGF0aCBleHByZXNzaW9ucyB0aGF0IHNlbGVjdCBmcm9tIHRoZSBpbnB1dC5cbiAgICpcbiAgICogQHNlZVxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2lucHV0LW91dHB1dC1pbnB1dHBhdGgtcGFyYW1zLmh0bWwjaW5wdXQtb3V0cHV0LXBhcmFtZXRlcnNcbiAgICpcbiAgICogQGRlZmF1bHQgTm8gcGFyYW1ldGVyc1xuICAgKi9cbiAgcmVhZG9ubHkgcGFyYW1ldGVycz86IHsgW25hbWU6IHN0cmluZ106IGFueSB9O1xufVxuXG4vKipcbiAqIERlZmluZSBhIFBhc3MgaW4gdGhlIHN0YXRlIG1hY2hpbmVcbiAqXG4gKiBBIFBhc3Mgc3RhdGUgY2FuIGJlIHVzZWQgdG8gdHJhbnNmb3JtIHRoZSBjdXJyZW50IGV4ZXVjdGlvbidzIHN0YXRlLlxuICovXG5leHBvcnQgY2xhc3MgUGFzcyBleHRlbmRzIFN0YXRlIGltcGxlbWVudHMgSU5leHRhYmxlIHtcbiAgcHVibGljIHJlYWRvbmx5IGVuZFN0YXRlczogSU5leHRhYmxlW107XG5cbiAgcHJpdmF0ZSByZWFkb25seSByZXN1bHQ/OiBSZXN1bHQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQYXNzUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy5yZXN1bHQgPSBwcm9wcy5yZXN1bHQ7XG4gICAgdGhpcy5lbmRTdGF0ZXMgPSBbdGhpc107XG4gIH1cblxuICAvKipcbiAgICogQ29udGludWUgbm9ybWFsIGV4ZWN1dGlvbiB3aXRoIHRoZSBnaXZlbiBzdGF0ZVxuICAgKi9cbiAgcHVibGljIG5leHQobmV4dDogSUNoYWluYWJsZSk6IENoYWluIHtcbiAgICBzdXBlci5tYWtlTmV4dChuZXh0LnN0YXJ0U3RhdGUpO1xuICAgIHJldHVybiBDaGFpbi5zZXF1ZW5jZSh0aGlzLCBuZXh0KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm4gdGhlIEFtYXpvbiBTdGF0ZXMgTGFuZ3VhZ2Ugb2JqZWN0IGZvciB0aGlzIHN0YXRlXG4gICAqL1xuICBwdWJsaWMgdG9TdGF0ZUpzb24oKTogb2JqZWN0IHtcbiAgICByZXR1cm4ge1xuICAgICAgVHlwZTogU3RhdGVUeXBlLlBBU1MsXG4gICAgICBDb21tZW50OiB0aGlzLmNvbW1lbnQsXG4gICAgICBSZXN1bHQ6IHRoaXMucmVzdWx0ID8gdGhpcy5yZXN1bHQudmFsdWUgOiB1bmRlZmluZWQsXG4gICAgICBSZXN1bHRQYXRoOiByZW5kZXJKc29uUGF0aCh0aGlzLnJlc3VsdFBhdGgpLFxuICAgICAgLi4udGhpcy5yZW5kZXJJbnB1dE91dHB1dCgpLFxuICAgICAgLi4udGhpcy5yZW5kZXJQYXJhbWV0ZXJzKCksXG4gICAgICAuLi50aGlzLnJlbmRlck5leHRFbmQoKSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbmRlciBQYXJhbWV0ZXJzIGluIEFTTCBKU09OIGZvcm1hdFxuICAgKi9cbiAgcHJpdmF0ZSByZW5kZXJQYXJhbWV0ZXJzKCk6IGFueSB7XG4gICAgcmV0dXJuIEZpZWxkVXRpbHMucmVuZGVyT2JqZWN0KHtcbiAgICAgIFBhcmFtZXRlcnM6IHRoaXMucGFyYW1ldGVycyxcbiAgICB9KTtcbiAgfVxufVxuIl19