# Bitmask decoder

Python wrapper to decode days-of-week bitmasks.

This mask is created by assigning an integer to each day of the week and summing up the integers of the relevant days.

It is assumed that the days are assigned as follows:

- Monday: 1
- Tuesday: 2
- Wednesday: 4
- Thursday: 8
- Friday: 16
- Saturday: 32
- Sunday: 64

Any combinations of these days can be summed up to create a mask for that specific combination. For example:

`42 = tuesday, thursday and saturday`

## Installation
bitmask-decoder is available via pip.

` pip install -i https://test.pypi.org/simple/ bitmask-decoder==0.0.6`


## 4 Functions
- `bitmask_decoder.decode_weekday()`
- `bitmask_decoder.decode_all_weekdays()`
- `bitmask_decoder.encode_weekday()`
- `bitmask_decoder.encode_all_weekdays()`

# Example

```python
import bitmask_decoder
bitmask_decoder.decode_weekday(17)                               
# ['Mon', 'Fri']

bitmask_decoder.decode_all_weekdays([9, 17, 127])                
# [['Mon', 'Thu'], ['Mon', 'Fri'], ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']]

bitmask_decoder.encode_weekday(["Monday", "Friday", "Saturday"]) 
# 49

bitmask_decoder.encode_all_weekdays([                            
    ["Monday", "Friday"],
    ["Friday", "Saturday", "Sunday"],
    ["Saturday", "Sunday"]
])
# [17, 112, 96]
```
