tables_sql = [
"""CREATE TABLE allergy_intolerances (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  clinical_status JSONB,
  verification_status JSONB,
  type VARCHAR(25),
  category JSONB,
  criticality VARCHAR(25),
  code_coding JSONB,
  patient_reference VARCHAR(45),
  recorded_date TIMESTAMP WITH TIME ZONE,
  reaction JSONB
);""",
"""CREATE TABLE care_plans (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  intent VARCHAR(25),
  category JSONB,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  period_start TIMESTAMP WITH TIME ZONE,
  period_end TEXT,
  care_team JSONB,
  addresses JSONB,
  activity JSONB
);""",
"""CREATE TABLE claims (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  type_coding JSONB,
  use VARCHAR(25),
  patient_reference VARCHAR(45),
  patient TEXT,
  billable_period_start TIMESTAMP WITH TIME ZONE,
  billable_period_end TIMESTAMP WITH TIME ZONE,
  created TIMESTAMP WITH TIME ZONE,
  provider_reference TEXT,
  provider TEXT,
  priority_coding JSONB,
  facility_reference TEXT,
  facility TEXT,
  diagnosis JSONB,
  supporting_info JSONB,
  procedure JSONB,
  prescription_reference VARCHAR(45),
  insurance JSONB,
  item JSONB,
  total_value TEXT,
  total_currency VARCHAR(4)
);""",
"""CREATE TABLE conditions (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  clinical_status JSONB,
  verification_status JSONB,
  category JSONB,
  code_coding JSONB,
  code TEXT,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  onset_date_time TIMESTAMP WITH TIME ZONE,
  recorded_date TIMESTAMP WITH TIME ZONE
);""",
"""CREATE TABLE devices (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  udi_carrier JSONB,
  status TEXT,
  distinct_identifier TEXT,
  manufacture_date TIMESTAMP WITH TIME ZONE,
  expiration_date TIMESTAMP WITH TIME ZONE,
  lot_number TEXT,
  serial_number TEXT,
  device_name JSONB,
  type_coding JSONB,
  patient_reference VARCHAR(45)
);""",
"""CREATE TABLE diagnostic_reports (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  category JSONB,
  code_coding JSONB,
  code TEXT,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  effective_date_time TEXT,
  issued_date_time TEXT,
  performer JSONB,
  result JSONB,
  presented_form JSONB
);""",
"""CREATE TABLE document_references (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  type_coding JSONB,
  category JSONB,
  subject_reference VARCHAR(45),
  date TIMESTAMP WITH TIME ZONE,
  author JSONB,
  custodian_reference TEXT,
  custodian TEXT,
  content JSONB,
  context_encounter JSONB,
  context_period_start TIMESTAMP WITH TIME ZONE,
  context_period_end TIMESTAMP WITH TIME ZONE
);""",
"""CREATE TABLE encounters (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  class_code VARCHAR(10),
  type JSONB,
  subject_reference VARCHAR(45),
  subject TEXT,
  participant JSONB,
  period_start TIMESTAMP WITH TIME ZONE,
  period_end TIMESTAMP WITH TIME ZONE,
  reason_code JSONB,
  hospitalization_discharge_disposition_coding JSONB,
  hospitalization_discharge_disposition TEXT,
  location JSONB,
  service_provider_reference TEXT,
  service_provider TEXT
);""",
"""CREATE TABLE explanation_of_benefits (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  contained JSONB,
  identifier JSONB,
  status VARCHAR(25),
  type_coding JSONB,
  use VARCHAR(25),
  patient_reference VARCHAR(45),
  billable_period_start TIMESTAMP WITH TIME ZONE,
  billable_period_end TIMESTAMP WITH TIME ZONE,
  created TIMESTAMP WITH TIME ZONE,
  insurer TEXT,
  provider_reference TEXT,
  referral_reference TEXT,
  facility_reference TEXT,
  facility TEXT,
  claim_reference VARCHAR(45),
  outcome TEXT,
  care_team JSONB,
  diagnosis JSONB,
  insurance JSONB,
  item JSONB,
  total JSONB,
  payment_amount_value TEXT,
  payment_amount_currency VARCHAR(4)
);""",
"""CREATE TABLE imaging_studies (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  identifier JSONB,
  status VARCHAR(25),
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  started_date_time TEXT,
  num_series TEXT,
  num_instances TEXT,
  procedure JSONB,
  location_reference TEXT,
  location TEXT,
  series JSONB
);""",
"""CREATE TABLE immunizations (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  vaccine_code JSONB,
  vaccine TEXT,
  patient_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  occurence_date_time TIMESTAMP WITH TIME ZONE,
  primary_source TEXT,
  location_reference TEXT,
  location TEXT
);""",
"""CREATE TABLE medications (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  code_coding JSONB,
  status VARCHAR(25)
);""",
"""CREATE TABLE medicaiton_administrations (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  medication_code JSONB,
  medication TEXT,
  subject_reference VARCHAR(45),
  context_reference VARCHAR(45),
  effective_date_time TEXT,
  reason_reference JSONB,
  dosage_value TEXT,
  dosage_rate TEXT
);""",
"""CREATE TABLE medication_requests (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  intent VARCHAR(25),
  medication_reference VARCHAR(45),
  medication_coding JSONB,
  medication TEXT,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  authored_on TIMESTAMP WITH TIME ZONE,
  requester_reference TEXT,
  requester TEXT,
  reason_reference JSONB,
  dosage_instruction JSONB
);""",
"""CREATE TABLE observations (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  category JSONB,
  code_coding JSONB,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  effective_date_time TEXT,
  issued_date_time TEXT,
  component JSONB,
  value_code JSONB,
  value_text TEXT,
  value TEXT,
  unit VARCHAR(25)
);""",
"""CREATE TABLE patients (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  extension JSONB,
  identifier JSONB,
  name JSONB,
  contact JSONB,
  gender VARCHAR(10),
  birth_date VARCHAR(10),
  deceased_date_time TEXT,
  address JSONB,
  marital_status_coding JSONB,
  marital_status VARCHAR(20),
  multiple_birth VARCHAR(5),
  multiple_birth_amount VARCHAR(5),
  communication JSONB
);""",
"""CREATE TABLE procedures (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  status VARCHAR(25),
  code_coding JSONB,
  code TEXT,
  subject_reference VARCHAR(45),
  encounter_reference VARCHAR(45),
  performed_period_start TIMESTAMP WITH TIME ZONE,
  performed_period_end TIMESTAMP WITH TIME ZONE,
  location_reference TEXT,
  location TEXT,
  reason_reference JSONB
);""",
"""CREATE TABLE provenances (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  target JSONB,
  recorded_date TIMESTAMP WITH TIME ZONE,
  agent JSONB
);""",
"""CREATE TABLE supply_deliveries (
  id VARCHAR(45) PRIMARY KEY,
  request_method VARCHAR(7),
  resource_type VARCHAR(50),
  resource_id VARCHAR(36),
  patient_reference VARCHAR(45),
  type_coding JSONB,
  supplied_quantity TEXT,
  item_code JSONB,
  item TEXT,
  occurence_date_time TIMESTAMP WITH TIME ZONE
);"""
]