# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Leaderboard(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Leaderboard - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'division': 'Division',
            'metric': 'AddressableEntityRef',
            'date_start_workday': 'date',
            'date_end_workday': 'date',
            'leaders': 'list[LeaderboardItem]',
            'user_rank': 'LeaderboardItem'
        }

        self.attribute_map = {
            'division': 'division',
            'metric': 'metric',
            'date_start_workday': 'dateStartWorkday',
            'date_end_workday': 'dateEndWorkday',
            'leaders': 'leaders',
            'user_rank': 'userRank'
        }

        self._division = None
        self._metric = None
        self._date_start_workday = None
        self._date_end_workday = None
        self._leaders = None
        self._user_rank = None

    @property
    def division(self):
        """
        Gets the division of this Leaderboard.
        The targeted division for this leaderboard

        :return: The division of this Leaderboard.
        :rtype: Division
        """
        return self._division

    @division.setter
    def division(self, division):
        """
        Sets the division of this Leaderboard.
        The targeted division for this leaderboard

        :param division: The division of this Leaderboard.
        :type: Division
        """
        
        self._division = division

    @property
    def metric(self):
        """
        Gets the metric of this Leaderboard.
        The metric id if the leaderboard is about a specific metric

        :return: The metric of this Leaderboard.
        :rtype: AddressableEntityRef
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this Leaderboard.
        The metric id if the leaderboard is about a specific metric

        :param metric: The metric of this Leaderboard.
        :type: AddressableEntityRef
        """
        
        self._metric = metric

    @property
    def date_start_workday(self):
        """
        Gets the date_start_workday of this Leaderboard.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_workday of this Leaderboard.
        :rtype: date
        """
        return self._date_start_workday

    @date_start_workday.setter
    def date_start_workday(self, date_start_workday):
        """
        Sets the date_start_workday of this Leaderboard.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_workday: The date_start_workday of this Leaderboard.
        :type: date
        """
        
        self._date_start_workday = date_start_workday

    @property
    def date_end_workday(self):
        """
        Gets the date_end_workday of this Leaderboard.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end_workday of this Leaderboard.
        :rtype: date
        """
        return self._date_end_workday

    @date_end_workday.setter
    def date_end_workday(self, date_end_workday):
        """
        Sets the date_end_workday of this Leaderboard.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end_workday: The date_end_workday of this Leaderboard.
        :type: date
        """
        
        self._date_end_workday = date_end_workday

    @property
    def leaders(self):
        """
        Gets the leaders of this Leaderboard.
        The list of leaders generated.

        :return: The leaders of this Leaderboard.
        :rtype: list[LeaderboardItem]
        """
        return self._leaders

    @leaders.setter
    def leaders(self, leaders):
        """
        Sets the leaders of this Leaderboard.
        The list of leaders generated.

        :param leaders: The leaders of this Leaderboard.
        :type: list[LeaderboardItem]
        """
        
        self._leaders = leaders

    @property
    def user_rank(self):
        """
        Gets the user_rank of this Leaderboard.
        The requesting user's rank

        :return: The user_rank of this Leaderboard.
        :rtype: LeaderboardItem
        """
        return self._user_rank

    @user_rank.setter
    def user_rank(self, user_rank):
        """
        Sets the user_rank of this Leaderboard.
        The requesting user's rank

        :param user_rank: The user_rank of this Leaderboard.
        :type: LeaderboardItem
        """
        
        self._user_rank = user_rank

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

