# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CredentialType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CredentialType - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'properties': 'object',
            'display_order': 'list[str]',
            'required': 'list[str]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'properties': 'properties',
            'display_order': 'displayOrder',
            'required': 'required'
        }

        self._id = None
        self._name = None
        self._properties = None
        self._display_order = None
        self._required = None

    @property
    def id(self):
        """
        Gets the id of this CredentialType.
        The globally unique identifier for the object.

        :return: The id of this CredentialType.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CredentialType.
        The globally unique identifier for the object.

        :param id: The id of this CredentialType.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this CredentialType.


        :return: The name of this CredentialType.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CredentialType.


        :param name: The name of this CredentialType.
        :type: str
        """
        
        self._name = name

    @property
    def properties(self):
        """
        Gets the properties of this CredentialType.
        Properties describing credentials of this type.

        :return: The properties of this CredentialType.
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CredentialType.
        Properties describing credentials of this type.

        :param properties: The properties of this CredentialType.
        :type: object
        """
        
        self._properties = properties

    @property
    def display_order(self):
        """
        Gets the display_order of this CredentialType.
        Order in which properties should be displayed in the UI.

        :return: The display_order of this CredentialType.
        :rtype: list[str]
        """
        return self._display_order

    @display_order.setter
    def display_order(self, display_order):
        """
        Sets the display_order of this CredentialType.
        Order in which properties should be displayed in the UI.

        :param display_order: The display_order of this CredentialType.
        :type: list[str]
        """
        
        self._display_order = display_order

    @property
    def required(self):
        """
        Gets the required of this CredentialType.
        Properties that are required fields.

        :return: The required of this CredentialType.
        :rtype: list[str]
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this CredentialType.
        Properties that are required fields.

        :param required: The required of this CredentialType.
        :type: list[str]
        """
        
        self._required = required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

