# coding: utf-8

"""
ExternalContactsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExternalContactsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_externalcontacts_contact(self, contact_id, **kwargs):
        """
        Delete an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contact(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_contact_note(self, contact_id, note_id, **kwargs):
        """
        Delete a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contact_note(contact_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `delete_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_contacts_schema(self, schema_id, **kwargs):
        """
        Delete a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contacts_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `delete_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization(self, external_organization_id, **kwargs):
        """
        Delete an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization_note(self, external_organization_id, note_id, **kwargs):
        """
        Delete a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization_note(external_organization_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `delete_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization_trustor(self, external_organization_id, **kwargs):
        """
        Unlink the Trustor for this External Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization_trustor(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization_trustor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization_trustor`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/trustor'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_relationship(self, relationship_id, **kwargs):
        """
        Delete a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_relationship(relationship_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `delete_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact(self, contact_id, **kwargs):
        """
        Fetch an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param list[str] expand: which fields, if any, to expand (externalOrganization,externalDataSources)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_note(self, contact_id, note_id, **kwargs):
        """
        Fetch a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_note(contact_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `get_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_notes(self, contact_id, **kwargs):
        """
        List notes for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_notes(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str sort_order: Sort order
        :param list[str] expand: which fields, if any, to expand
        :return: NoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'page_size', 'page_number', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_notes`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts(self, **kwargs):
        """
        Search for external contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: User supplied search keywords (no special syntax is currently supported)
        :param str sort_order: Sort order
        :param list[str] expand: which fields, if any, to expand
        :return: ContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'q', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema(self, schema_id, **kwargs):
        """
        Get a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema_version(self, schema_id, version_id, **kwargs):
        """
        Get a specific version of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema_version(schema_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param str version_id: Schema version (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_externalcontacts_contacts_schema_version`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema_versions(self, schema_id, **kwargs):
        """
        Get all versions of an external contact's schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema_versions(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema_versions`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schemas(self, **kwargs):
        """
        Get a list of schemas.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization(self, external_organization_id, **kwargs):
        """
        Fetch an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param str expand: which fields, if any, to expand (externalDataSources)
        :param bool include_trustors: (true or false) whether or not to include trustor information embedded in the externalOrganization
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'expand', 'include_trustors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_trustors' in params:
            query_params['includeTrustors'] = params['include_trustors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_contacts(self, external_organization_id, **kwargs):
        """
        Search for external contacts in an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_contacts(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: User supplied search keywords (no special syntax is currently supported)
        :param str sort_order: Sort order
        :param list[str] expand: which fields, if any, to expand
        :return: ContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'q', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_contacts`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_note(self, external_organization_id, note_id, **kwargs):
        """
        Fetch a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_note(external_organization_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `get_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_notes(self, external_organization_id, **kwargs):
        """
        List notes for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_notes(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str sort_order: Sort order
        :param list[str] expand: which fields, if any, to expand
        :return: NoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_notes`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_relationships(self, external_organization_id, **kwargs):
        """
        Fetch a relationship for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_relationships(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str expand: which fields, if any, to expand
        :param str sort_order: Sort order
        :return: RelationshipListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'expand', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_relationships`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/relationships'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelationshipListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations(self, **kwargs):
        """
        Search for external organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: Search query
        :param list[str] trustor_id: Search for external organizations by trustorIds (limit 25). If supplied, the 'q' parameters is ignored. Items are returned in the order requested
        :param str sort_order: Sort order
        :param list[str] expand: which fields, if any, to expand
        :param bool include_trustors: (true or false) whether or not to include trustor information embedded in the externalOrganization
        :return: ExternalOrganizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'q', 'trustor_id', 'sort_order', 'expand', 'include_trustors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'trustor_id' in params:
            query_params['trustorId'] = params['trustor_id']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_trustors' in params:
            query_params['includeTrustors'] = params['include_trustors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema(self, schema_id, **kwargs):
        """
        Get a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema_version(self, schema_id, version_id, **kwargs):
        """
        Get a specific version of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema_version(schema_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param str version_id: Schema version (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_externalcontacts_organizations_schema_version`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema_versions(self, schema_id, **kwargs):
        """
        Get all versions of an external organization's schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema_versions(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema_versions`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schemas(self, **kwargs):
        """
        Get a list of schemas.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_relationship(self, relationship_id, **kwargs):
        """
        Fetch a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_relationship(relationship_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :param str expand: which fields, if any, to expand
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `get_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_reversewhitepageslookup(self, lookup_val, **kwargs):
        """
        Look up contacts and externalOrganizations based on an attribute. Maximum of 25 values returned.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_reversewhitepageslookup(lookup_val, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookup_val: User supplied value to lookup contacts/externalOrganizations (supports email addresses, e164 phone numbers, Twitter screen names) (required)
        :param list[str] expand: which field, if any, to expand
        :return: ReverseWhitepagesLookupResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookup_val', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_reversewhitepageslookup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'lookup_val' is set
        if ('lookup_val' not in params) or (params['lookup_val'] is None):
            raise ValueError("Missing the required parameter `lookup_val` when calling `get_externalcontacts_reversewhitepageslookup`")


        resource_path = '/api/v2/externalcontacts/reversewhitepageslookup'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'lookup_val' in params:
            query_params['lookupVal'] = params['lookup_val']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReverseWhitepagesLookupResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_contacts(self, **kwargs):
        """
        Scan for external contacts using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_contacts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of contacts per page; must be between 10 and 200, default is 100)
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_contacts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_notes(self, **kwargs):
        """
        Scan for notes using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_notes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of notes per page; must be between 10 and 200, default is 100)
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorNoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_notes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/notes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorNoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_organizations(self, **kwargs):
        """
        Scan for external organizations using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_organizations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of organizations per page; must be between 10 and 200, default is 100)
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorOrganizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_organizations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorOrganizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_relationships(self, **kwargs):
        """
        Scan for relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_relationships(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of relationships per page; must be between 10 and 200, default is 100)
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorRelationshipListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_relationships" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorRelationshipListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts(self, body, **kwargs):
        """
        Bulk fetch contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkFetchContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_add(self, body, **kwargs):
        """
        Bulk add contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkContactsRequest body: Contacts (required)
        :return: BulkContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_add`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_remove(self, body, **kwargs):
        """
        Bulk remove contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_update(self, body, **kwargs):
        """
        Bulk update contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkContactsRequest body: Contacts (required)
        :return: BulkContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_update`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes(self, body, **kwargs):
        """
        Bulk fetch notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Note ids (required)
        :return: BulkFetchNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes`")


        resource_path = '/api/v2/externalcontacts/bulk/notes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_add(self, body, **kwargs):
        """
        Bulk add notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkNotesRequest body: Notes (required)
        :return: BulkNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_add`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_remove(self, body, **kwargs):
        """
        Bulk remove notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Note ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_update(self, body, **kwargs):
        """
        Bulk update notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkNotesRequest body: Notes (required)
        :return: BulkNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_update`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations(self, body, **kwargs):
        """
        Bulk fetch organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Organizations ids (required)
        :return: BulkFetchOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_add(self, body, **kwargs):
        """
        Bulk add organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkOrganizationsRequest body: Organizations (required)
        :return: BulkOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_add`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_remove(self, body, **kwargs):
        """
        Bulk remove organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Organization ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_update(self, body, **kwargs):
        """
        Bulk update organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkOrganizationsRequest body: Organizations (required)
        :return: BulkOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_update`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships(self, body, **kwargs):
        """
        Bulk fetch relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Relationships ids (required)
        :return: BulkFetchRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_add(self, body, **kwargs):
        """
        Bulk add relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkRelationshipsRequest body: Relationships (required)
        :return: BulkRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_add`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_remove(self, body, **kwargs):
        """
        Bulk remove relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Relationships ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_update(self, body, **kwargs):
        """
        Bulk update relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkRelationshipsRequest body: Relationships (required)
        :return: BulkRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_update`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contact_notes(self, contact_id, body, **kwargs):
        """
        Create a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contact_notes(contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param Note body: ExternalContact (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contact_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `post_externalcontacts_contact_notes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contact_notes`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts(self, body, **kwargs):
        """
        Create an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalContact body: ExternalContact (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts`")


        resource_path = '/api/v2/externalcontacts/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts_schemas(self, body, **kwargs):
        """
        Create a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts_schemas`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organization_notes(self, external_organization_id, body, **kwargs):
        """
        Create a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organization_notes(external_organization_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param Note body: ExternalContact (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organization_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `post_externalcontacts_organization_notes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organization_notes`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organizations(self, body, **kwargs):
        """
        Create an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organizations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalOrganization body: ExternalOrganization (required)
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organizations`")


        resource_path = '/api/v2/externalcontacts/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organizations_schemas(self, body, **kwargs):
        """
        Create a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organizations_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organizations_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organizations_schemas`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_relationships(self, body, **kwargs):
        """
        Create a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_relationships(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Relationship body: Relationship (required)
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_relationships`")


        resource_path = '/api/v2/externalcontacts/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contact(self, contact_id, body, **kwargs):
        """
        Update an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contact(contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param ExternalContact body: ExternalContact (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_externalcontacts_contact`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contact_note(self, contact_id, note_id, body, **kwargs):
        """
        Update a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contact_note(contact_id, note_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :param Note body: Note (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `put_externalcontacts_contact_note`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contacts_schema(self, schema_id, body, **kwargs):
        """
        Update a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contacts_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_externalcontacts_contacts_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_conversation(self, body, conversation_id, **kwargs):
        """
        Associate/disassociate an external contact with a conversation
        To associate, supply a value for the externalContactId.  To disassociate, do not include the property at all.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_conversation(body, conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConversationAssociation body: ConversationAssociation (required)
        :param str conversation_id: Conversation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_conversation`")
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_externalcontacts_conversation`")


        resource_path = '/api/v2/externalcontacts/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization(self, external_organization_id, body, **kwargs):
        """
        Update an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization(external_organization_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param ExternalOrganization body: ExternalOrganization (required)
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization_note(self, external_organization_id, note_id, body, **kwargs):
        """
        Update a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization_note(external_organization_id, note_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :param Note body: Note (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `put_externalcontacts_organization_note`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization_trustor_trustor_id(self, external_organization_id, trustor_id, **kwargs):
        """
        Links a Trustor with an External Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization_trustor_trustor_id(external_organization_id, trustor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param str trustor_id: Trustor ID (required)
        :return: ExternalOrganizationTrustorLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'trustor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization_trustor_trustor_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization_trustor_trustor_id`")
        # verify the required parameter 'trustor_id' is set
        if ('trustor_id' not in params) or (params['trustor_id'] is None):
            raise ValueError("Missing the required parameter `trustor_id` when calling `put_externalcontacts_organization_trustor_trustor_id`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/trustor/{trustorId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'trustor_id' in params:
            path_params['trustorId'] = params['trustor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationTrustorLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organizations_schema(self, schema_id, body, **kwargs):
        """
        Update a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organizations_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organizations_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_externalcontacts_organizations_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organizations_schema`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_relationship(self, relationship_id, body, **kwargs):
        """
        Update a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_relationship(relationship_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :param Relationship body: Relationship (required)
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `put_externalcontacts_relationship`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
