import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupLdapLinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`, `master`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#access_level GroupLdapLink#access_level}
    */
    readonly accessLevel?: string;
    /**
    * The CN of the LDAP group to link with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#cn GroupLdapLink#cn}
    */
    readonly cn: string;
    /**
    * If true, then delete and replace an existing LDAP link if one exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#force GroupLdapLink#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`, `master`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#group_access GroupLdapLink#group_access}
    */
    readonly groupAccess?: string;
    /**
    * The id of the GitLab group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#group_id GroupLdapLink#group_id}
    */
    readonly groupId: string;
    /**
    * The name of the LDAP provider as stored in the GitLab database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link#ldap_provider GroupLdapLink#ldap_provider}
    */
    readonly ldapProvider: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link gitlab_group_ldap_link}
*/
export declare class GroupLdapLink extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_ldap_link";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link gitlab_group_ldap_link} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupLdapLinkConfig
    */
    constructor(scope: Construct, id: string, config: GroupLdapLinkConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _cn?;
    get cn(): string;
    set cn(value: string);
    get cnInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _groupAccess?;
    get groupAccess(): string;
    set groupAccess(value: string);
    resetGroupAccess(): void;
    get groupAccessInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _ldapProvider?;
    get ldapProvider(): string;
    set ldapProvider(value: string);
    get ldapProviderInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
