import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access level for the group access token. Valid values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token#access_level GroupAccessToken#access_level}
    */
    readonly accessLevel?: string;
    /**
    * The token expires at midnight UTC on that date. The date must be in the format YYYY-MM-DD. Default is never.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token#expires_at GroupAccessToken#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * The ID or path of the group to add the group access token to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token#group GroupAccessToken#group}
    */
    readonly group: string;
    /**
    * The name of the group access token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token#name GroupAccessToken#name}
    */
    readonly name: string;
    /**
    * The scope for the group access token. It determines the actions which can be performed when authenticating with this token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token#scopes GroupAccessToken#scopes}
    */
    readonly scopes: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token gitlab_group_access_token}
*/
export declare class GroupAccessToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_access_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_access_token gitlab_group_access_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupAccessTokenConfig
    */
    constructor(scope: Construct, id: string, config: GroupAccessTokenConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get revoked(): cdktf.IResolvable;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    get token(): string;
    get userId(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
