import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of a tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tag#name DataGitlabProjectTag#name}
    */
    readonly name: string;
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tag#project DataGitlabProjectTag#project}
    */
    readonly project: string;
}
export interface DataGitlabProjectTagCommit {
}
export declare function dataGitlabProjectTagCommitToTerraform(struct?: DataGitlabProjectTagCommit): any;
export declare class DataGitlabProjectTagCommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectTagCommit | undefined;
    set internalValue(value: DataGitlabProjectTagCommit | undefined);
    get authorEmail(): string;
    get authorName(): string;
    get authoredDate(): string;
    get committedDate(): string;
    get committerEmail(): string;
    get committerName(): string;
    get id(): string;
    get message(): string;
    get parentIds(): string[];
    get shortId(): string;
    get title(): string;
}
export declare class DataGitlabProjectTagCommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectTagCommitOutputReference;
}
export interface DataGitlabProjectTagRelease {
}
export declare function dataGitlabProjectTagReleaseToTerraform(struct?: DataGitlabProjectTagRelease): any;
export declare class DataGitlabProjectTagReleaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectTagRelease | undefined;
    set internalValue(value: DataGitlabProjectTagRelease | undefined);
    get description(): string;
    get tagName(): string;
}
export declare class DataGitlabProjectTagReleaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectTagReleaseOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_tag gitlab_project_tag}
*/
export declare class DataGitlabProjectTag extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_tag gitlab_project_tag} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectTagConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectTagConfig);
    private _commit;
    get commit(): DataGitlabProjectTagCommitList;
    get id(): string;
    get message(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get protected(): cdktf.IResolvable;
    private _release;
    get release(): DataGitlabProjectTagReleaseList;
    get target(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
