import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectIssueConfig extends cdktf.TerraformMetaArguments {
    /**
    * The internal ID of the project's issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issue#iid DataGitlabProjectIssue#iid}
    */
    readonly iid: number;
    /**
    * The name or ID of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_issue#project DataGitlabProjectIssue#project}
    */
    readonly project: string;
}
export interface DataGitlabProjectIssueTaskCompletionStatus {
}
export declare function dataGitlabProjectIssueTaskCompletionStatusToTerraform(struct?: DataGitlabProjectIssueTaskCompletionStatus): any;
export declare class DataGitlabProjectIssueTaskCompletionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectIssueTaskCompletionStatus | undefined;
    set internalValue(value: DataGitlabProjectIssueTaskCompletionStatus | undefined);
    get completedCount(): number;
    get count(): number;
}
export declare class DataGitlabProjectIssueTaskCompletionStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectIssueTaskCompletionStatusOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_issue gitlab_project_issue}
*/
export declare class DataGitlabProjectIssue extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_issue";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_issue gitlab_project_issue} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectIssueConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectIssueConfig);
    get assigneeIds(): number[];
    get authorId(): number;
    get closedAt(): string;
    get closedByUserId(): number;
    get confidential(): cdktf.IResolvable;
    get createdAt(): string;
    get description(): string;
    get discussionLocked(): cdktf.IResolvable;
    get discussionToResolve(): string;
    get downvotes(): number;
    get dueDate(): string;
    get epicId(): number;
    get epicIssueId(): number;
    get externalId(): string;
    get humanTimeEstimate(): string;
    get humanTotalTimeSpent(): string;
    get id(): string;
    private _iid?;
    get iid(): number;
    set iid(value: number);
    get iidInput(): number | undefined;
    get issueId(): number;
    get issueLinkId(): number;
    get issueType(): string;
    get labels(): string[];
    links(key: string): string | cdktf.IResolvable;
    get mergeRequestToResolveDiscussionsOf(): number;
    get mergeRequestsCount(): number;
    get milestoneId(): number;
    get movedToId(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    references(key: string): string | cdktf.IResolvable;
    get state(): string;
    get subscribed(): cdktf.IResolvable;
    private _taskCompletionStatus;
    get taskCompletionStatus(): DataGitlabProjectIssueTaskCompletionStatusList;
    get timeEstimate(): number;
    get title(): string;
    get totalTimeSpent(): number;
    get updatedAt(): string;
    get upvotes(): number;
    get userNotesCount(): number;
    get webUrl(): string;
    get weight(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
