"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""


import requests as requests_http
from ._hooks import SDKHooks
from .utils import utils
from .utils.retries import RetryConfig
from dataclasses import dataclass
from ivycheck import models
from typing import Callable, Dict, Optional, Tuple, Union


SERVER_PROD = 'prod'
r"""Production server"""
SERVER_SANDBOX = 'sandbox'
r"""Local server"""
SERVERS = {
	SERVER_PROD: 'https://api.ivycheck.com',
	SERVER_SANDBOX: 'http://localhost:8000',
}
"""Contains the list of servers available to the SDK"""


@dataclass
class SDKConfiguration:
    client: requests_http.Session
    security: Union[models.Security,Callable[[], models.Security]] = None
    server_url: Optional[str] = ''
    server: Optional[str] = ''
    language: str = 'python'
    openapi_doc_version: str = '0.0.1'
    sdk_version: str = '0.11.15'
    gen_version: str = '2.493.4'
    user_agent: str = 'speakeasy-sdk/python 0.11.15 2.493.4 0.0.1 ivycheck'
    retry_config: Optional[RetryConfig] = None

    def __post_init__(self):
        self._hooks = SDKHooks()

    def get_server_details(self) -> Tuple[str, Dict[str, str]]:
        if self.server_url is not None and self.server_url != '':
            return utils.remove_suffix(self.server_url, '/'), {}
        if not self.server:
            self.server = SERVER_PROD

        if self.server not in SERVERS:
            raise ValueError(f"Invalid server \"{self.server}\"")

        return SERVERS[self.server], {}


    def get_hooks(self) -> SDKHooks:
        return self._hooks
