"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlureeConn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const flureenjs = require("@fluree/flureenjs");
const globalAny = global;
globalAny.XMLHttpRequest = require("xhr2");
globalAny.WebSocket = require("ws");
/**
 * @experimental
 */
class FlureeConn {
    /**
     * @experimental
     */
    constructor(props) {
        this.url = props.url;
        this.conn = this.connect();
    }
    /**
     * @experimental
     */
    async connect() {
        return await flureenjs.connect_p(this.url, {}).then((c) => { return c; });
    }
    /**
     * @experimental
     */
    async db(db_name) {
        const conn = await this.conn;
        return flureenjs.db_p(conn, db_name).then((d) => { return d; });
    }
    /**
     * @experimental
     */
    async query(q) {
        const db = await this.db("main/test");
        const results = await flureenjs.query(db, q).then((resp) => { return resp; });
        return results;
    }
    /**
     * @experimental
     */
    async transact(q, ledger) {
        const conn = await this.conn;
        const results = await flureenjs.transact(conn, ledger, q).then((resp) => { return resp; });
        return results;
    }
}
exports.FlureeConn = FlureeConn;
_a = JSII_RTTI_SYMBOL_1;
FlureeConn[_a] = { fqn: "fluree-jsii.FlureeConn", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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