/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/audit/api/account/menu": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Menu */
    get: operations["corptools_api_core_menu_get_character_menu"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/search/system/{search_text}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get System Search */
    get: operations["corptools_api_core_search_get_system_search"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/search/location/{search_text}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Location Search */
    get: operations["corptools_api_core_search_get_location_search"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/search/item/group/{search_text}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Group Search */
    get: operations["corptools_api_core_search_get_group_search"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/asset/locations": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Asset Locations */
    get: operations["corptools_api_character_assets_get_character_asset_locations"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/asset/{location_id}/list": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Asset List */
    get: operations["corptools_api_character_assets_get_character_asset_list"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/asset/{item_id}/contents": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Asset Contents */
    get: operations["corptools_api_character_assets_get_character_asset_contents"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/asset/{location_id}/groups": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Asset Groups */
    get: operations["corptools_api_character_assets_get_character_asset_groups"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/clones": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Clones */
    get: operations["corptools_api_character_clones_get_character_clones"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/wallet": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Wallet */
    get: operations["corptools_api_character_finances_get_character_wallet"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/orders": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Orders */
    get: operations["corptools_api_character_finances_get_character_orders"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/market": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Market */
    get: operations["corptools_api_character_finances_get_character_market"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/wallet/activity": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Wallet Activity */
    get: operations["corptools_api_character_finances_get_character_wallet_activity"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/contracts": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Contracts */
    get: operations["corptools_api_character_finances_get_character_contracts"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/loyalty": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Loyalty Points */
    get: operations["corptools_api_character_finances_get_character_loyalty_Points"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/contacts": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Contacts */
    get: operations["corptools_api_character_interactions_get_character_contacts"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/mail": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Mail */
    get: operations["corptools_api_character_interactions_get_character_mail"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/mail/{mail_id}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Mail Message Request */
    get: operations["corptools_api_character_interactions_get_mail_message_request"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/notifications": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Notifications */
    get: operations["corptools_api_character_interactions_get_character_notifications"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/list": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Account List */
    get: operations["corptools_api_character_list_get_account_list"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/mining/chars": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get All Characters Character Mining */
    get: operations["corptools_api_character_mining_get_all_characters_character_mining"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/mining": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Mining */
    get: operations["corptools_api_character_mining_get_character_mining"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/roles": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Roles */
    get: operations["corptools_api_character_roles_get_character_roles"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/skills": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Skills */
    get: operations["corptools_api_character_skills_get_character_skills"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/skill/history": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Skill History */
    get: operations["corptools_api_character_skills_get_character_skill_history"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/skillqueues": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Skillqueues */
    get: operations["corptools_api_character_skills_get_character_skillqueues"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/doctrines": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Doctrines */
    get: operations["corptools_api_character_skills_get_character_doctrines"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/status": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Status */
    get: operations["corptools_api_character_status_get_character_status"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/qs": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Qs Test */
    get: operations["corptools_api_character_status_get_qs_test"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/pubdata": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Character Pubdata */
    get: operations["corptools_api_character_status_get_character_pubdata"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/characters/refresh": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    get?: never;
    put?: never;
    /** Post Characters Refresh */
    post: operations["corptools_api_character_refresh_post_characters_refresh"];
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/refresh": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    get?: never;
    put?: never;
    /** Post Account Refresh */
    post: operations["corptools_api_character_refresh_post_account_refresh"];
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/glance/assets": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Assets */
    get: operations["corptools_api_character_at_a_glance_get_glance_assets"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/glance/activities": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Activities */
    get: operations["corptools_api_character_at_a_glance_get_glance_activities"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/glance/ratting": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Ratting Counts */
    get: operations["corptools_api_character_at_a_glance_get_glance_ratting_counts"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/account/{character_id}/glance/faction": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Factions */
    get: operations["corptools_api_character_at_a_glance_get_glance_factions"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/asset/locations": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Asset Locations */
    get: operations["corptools_api_corporation_assets_get_corporation_asset_locations"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/asset/{location_id}/list": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Asset List */
    get: operations["corptools_api_corporation_assets_get_corporation_asset_list"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/asset/{item_id}/contents": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Asset Contents */
    get: operations["corptools_api_corporation_assets_get_corporation_asset_contents"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/asset/{location_id}/groups": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Asset Groups */
    get: operations["corptools_api_corporation_assets_get_corporation_asset_groups"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/wallettypes": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Wallet Types */
    get: operations["corptools_api_corporation_finances_get_corporation_wallet_types"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/wallet": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Wallet */
    get: operations["corptools_api_corporation_finances_get_corporation_wallet"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/divisions": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Divisions */
    get: operations["corptools_api_corporation_finances_get_corporation_divisions"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/list": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Corporation Status */
    get: operations["corptools_api_corporation_list_get_visible_corporation_status"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/{corporation_id}/status": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Status */
    get: operations["corptools_api_corporation_status_get_corporation_status"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/character/status": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Character Status */
    get: operations["corptools_api_corporation_status_get_corporation_character_status"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/dashboard/gates": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Dashboard Gates */
    get: operations["corptools_api_corporation_dashboards_get_dashboard_gates"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/dashboard/sov": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Dashboard Sov */
    get: operations["corptools_api_corporation_dashboards_get_dashboard_sov"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/dashboard/metenox": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Dashboard Drills */
    get: operations["corptools_api_corporation_dashboards_get_dashboard_drills"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/dashboard/dens": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Dens */
    get: operations["corptools_api_corporation_dashboards_get_visible_dens"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/structures": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Structures */
    get: operations["corptools_api_corporation_structures_get_visible_structures"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/structures/fuel": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Fuel Data */
    get: operations["corptools_api_corporation_structures_get_fuel_data"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/structures/{structure_id}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Structure Fitting */
    get: operations["corptools_api_corporation_structures_get_corporation_structure_fitting"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/pocos": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Pocos */
    get: operations["corptools_api_corporation_structures_get_visible_pocos"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extra/jb/export": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Jb Link */
    get: operations["corptools_api_corporation_structures_get_jb_link"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/starbases": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Starbases */
    get: operations["corptools_api_corporation_structures_get_visible_starbases"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corp/starbase/{starbase_id}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Visible Starbase Fit */
    get: operations["corptools_api_corporation_structures_get_visible_starbase_fit"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/glance/assets": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Assets Corp */
    get: operations["corptools_api_corporation_at_a_glance_get_glance_assets_corp"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/glance/activities/pve": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Activities Pve */
    get: operations["corptools_api_corporation_at_a_glance_get_glance_activities_pve"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/glance/activities/indy": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Activities Indy */
    get: operations["corptools_api_corporation_at_a_glance_get_glance_activities_indy"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/glance/activities/mining": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Activities */
    get: operations["corptools_api_corporation_at_a_glance_get_glance_activities"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/glance/faction": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Glance Factions */
    get: operations["corptools_api_corporation_at_a_glance_get_glance_factions"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/corporation/{corporation_id}/mining": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /** Get Corporation Agregated Mining */
    get: operations["corptools_api_corporation_mining_get_corporation_agregated_mining"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/fit2skills/{fit_id}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Fit Skills
     * @description Turn a Fitting into a skill list json.
     */
    get: operations["corptools_api_extras_fittings_get_fit_skills"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/dogma/{type_id}": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Dogma
     * @description Load dogma for a type_id.
     */
    get: operations["corptools_api_extras_fittings_get_dogma"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/pingbot/assets/send": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    get?: never;
    put?: never;
    /** Post Send Pings Assets */
    post: operations["corptools_api_extras_asset_pinger_post_send_pings_assets"];
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/pingbot/assets/counts": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    get?: never;
    put?: never;
    /** Post Test Pings Assets */
    post: operations["corptools_api_extras_asset_pinger_post_test_pings_assets"];
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/clone_death/{location_id}/{look_back}/": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Dead Clones In Location
     * @description Find Dead Clones :pepewhy:
     */
    get: operations["corptools_api_extras_clone_deaths_get_dead_clones_in_location"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/test/newapi1": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Test Api Bravadosih
     * @description Not for real use!
     *     this is kinda like bravado in use... no type hinting
     */
    get: operations["corptools_api_extras_testing_get_test_api_bravadosih"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/test/newapi2": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Test Api Openapi
     * @description Not for real use!
     *     this has type hinting
     */
    get: operations["corptools_api_extras_testing_get_test_api_openapi"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/test/newapi3": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Test Api Openapi 3
     * @description Not for real use!
     *     this has type hinting
     */
    get: operations["corptools_api_extras_testing_get_test_api_openapi_3"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
  "/audit/api/extras/test/newapi4": {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    /**
     * Get Test Api Openapi 4
     * @description Not for real use!
     *     this has type hinting
     */
    get: operations["corptools_api_extras_testing_get_test_api_openapi_4"];
    put?: never;
    post?: never;
    delete?: never;
    options?: never;
    head?: never;
    patch?: never;
    trace?: never;
  };
}
export type webhooks = Record<string, never>;
export interface components {
  schemas: {
    /** MenuCategory */
    MenuCategory: {
      /** Name */
      name: string;
      /** Link */
      link?: string;
      /** Links */
      links?: components["schemas"]["MenuLink"][];
    };
    /** MenuLink */
    MenuLink: {
      /** Name */
      name: string;
      /** Link */
      link?: string;
    };
    /** EveName */
    EveName: {
      /** Id */
      id: number;
      /** Name */
      name: string;
      /** Cat */
      cat?: string | null;
      /** Cat Id */
      cat_id?: number | null;
    };
    /** ValueLabel */
    ValueLabel: {
      /** Value */
      value: string | number | boolean;
      /** Label */
      label: string;
    };
    /** Character */
    Character: {
      /** Character Name */
      character_name: string;
      /** Character Id */
      character_id: number;
      /** Corporation Id */
      corporation_id: number;
      /** Corporation Name */
      corporation_name: string;
      /** Alliance Id */
      alliance_id?: number | null;
      /** Alliance Name */
      alliance_name?: string | null;
    };
    /** CharacterAssetItem */
    CharacterAssetItem: {
      /** Id */
      id: number;
      item: components["schemas"]["EveName"];
      /**
       * Quantity
       * @default 0
       */
      quantity: number;
      location?: components["schemas"]["EveLocation"] | null;
      /** Expand */
      expand?: boolean | null;
      character: components["schemas"]["Character"];
    };
    /** EveLocation */
    EveLocation: {
      /** Id */
      id: number;
      /** Name */
      name: string;
      /** Cat */
      cat?: string | null;
      /** Cat Id */
      cat_id?: number | null;
      solar_system?: components["schemas"]["SolarSystem"] | null;
    };
    /** SolarSystem */
    SolarSystem: {
      system: components["schemas"]["EveName"];
      constellation: components["schemas"]["EveName"];
      region: components["schemas"]["EveName"];
      /** Security Status */
      security_status?: number | null;
    };
    /** CharacterAssetGroups */
    CharacterAssetGroups: {
      /** Name */
      name: string;
      /** Items */
      items?: components["schemas"]["ValueLabel"][];
    };
    /** CharacterClone */
    CharacterClone: {
      /** Name */
      name?: string | null;
      location?: components["schemas"]["EveName"] | null;
      /** Implants */
      implants?: components["schemas"]["EveName"][];
    };
    /** CharacterClones */
    CharacterClones: {
      character: components["schemas"]["Character"];
      /** Clones */
      clones?: components["schemas"]["CharacterClone"][];
      home?: components["schemas"]["EveName"] | null;
      /** Last Station Change */
      last_station_change?: string | null;
      /** Last Clone Jump */
      last_clone_jump?: string | null;
    };
    /** Input */
    Input: {
      /**
       * Limit
       * @default 30000
       */
      limit: number;
      /**
       * Offset
       * @default 0
       */
      offset: number;
    };
    /** CharacterWalletEvent */
    CharacterWalletEvent: {
      character: components["schemas"]["Character"];
      /** Id */
      id: number;
      /**
       * Date
       * Format: date-time
       */
      date: string;
      first_party: components["schemas"]["EveName"];
      second_party: components["schemas"]["EveName"];
      /** Ref Type */
      ref_type: string;
      /** Balance */
      balance: number;
      /** Amount */
      amount: number;
      /**
       * Own Account
       * @default true
       */
      own_account: boolean | null;
      /** Reason */
      reason?: string | null;
      /** Description */
      description?: string | null;
    };
    /** PagedCharacterWalletEvent */
    PagedCharacterWalletEvent: {
      /** Items */
      items: components["schemas"]["CharacterWalletEvent"][];
      /** Count */
      count: number;
    };
    /** CharacterOrder */
    CharacterOrder: {
      character: components["schemas"]["Character"];
      /**
       * Date
       * Format: date-time
       */
      date: string;
      /** Duration */
      duration: number;
      /** Volume Min */
      volume_min?: number | null;
      /** Volume Remain */
      volume_remain: number;
      /** Volume Total */
      volume_total: number;
      item: components["schemas"]["EveName"];
      /** Price */
      price: number;
      /** Escrow */
      escrow?: number | null;
      /** Buy Order */
      buy_order?: boolean | null;
      location?: components["schemas"]["EveName"] | null;
    };
    /** CharacterMarket */
    CharacterMarket: {
      /** Expired */
      expired?: components["schemas"]["CharacterOrder"][];
      /** Active */
      active?: components["schemas"]["CharacterOrder"][];
      /** Total Active */
      total_active: number;
      /** Total Expired */
      total_expired: number;
    };
    /** CharacterContract */
    CharacterContract: {
      /** Character */
      character: string | components["schemas"]["Character"];
      /** Id */
      id?: number | null;
      /** Contract */
      contract?: number | null;
      /**
       * Items
       * @default []
       */
      items: components["schemas"]["ContractItems"][] | null;
      /** Contract Type */
      contract_type: string;
      /** Availbility */
      availbility?: string | null;
      /** Title */
      title?: string | null;
      /** Acceptor */
      acceptor?: string | null;
      /** Assignee */
      assignee?: string | null;
      /** Issuer */
      issuer?: string | null;
      /** Issuer Corporation Id */
      issuer_corporation_id?: string | null;
      /** Days To Complete */
      days_to_complete: number;
      /** Collateral */
      collateral: number;
      /** Buyout */
      buyout: number;
      /** Price */
      price: number;
      /** Reward */
      reward: number;
      /** Volume */
      volume: number;
      /** Status */
      status: string;
      /** Start Location Id */
      start_location_id?: number | null;
      /** End Location Id */
      end_location_id?: number | null;
      start_location?: components["schemas"]["EveName"] | null;
      end_location?: components["schemas"]["EveName"] | null;
      /** For Corporation */
      for_corporation: boolean;
      /**
       * Own Account
       * @default false
       */
      own_account: boolean | null;
      /** Date Accepted */
      date_accepted?: string | null;
      /** Date Completed */
      date_completed?: string | null;
      /** Date Expired */
      date_expired?: string | null;
      /** Date Issued */
      date_issued?: string | null;
    };
    /** ContractItems */
    ContractItems: {
      /** Is Included */
      is_included: boolean;
      /** Is Singleton */
      is_singleton: boolean;
      /** Quantity */
      quantity?: number | null;
      /** Raw Quantity */
      raw_quantity?: number | null;
      /** Record Id */
      record_id: number;
      /** Type Name */
      type_name: string;
    };
    /** LoyaltyPoints */
    LoyaltyPoints: {
      character: components["schemas"]["Character"];
      corporation: components["schemas"]["EveName"];
      /** Amount */
      amount: number;
    };
    /** Contact */
    Contact: {
      character: components["schemas"]["Character"];
      contact: components["schemas"]["EveName"];
      /** Standing */
      standing: number;
      /** Labels */
      labels?: components["schemas"]["ValueLabel"][];
      /** Blocked */
      blocked: boolean;
      /** Watched */
      watched: boolean;
    };
    /** CharacterNotification */
    CharacterNotification: {
      character: components["schemas"]["Character"];
      /** Notification Text */
      notification_text: string;
      /** Notification Type */
      notification_type: string;
      /**
       * Timestamp
       * Format: date-time
       */
      timestamp: string;
      /** Is Read */
      is_read?: boolean | null;
    };
    /** AccountStatus */
    AccountStatus: {
      /** Characters */
      characters?: components["schemas"]["CharacterStatus"][];
      main: components["schemas"]["Character"];
      /**
       * Orphan
       * @default false
       */
      orphan: boolean;
    };
    /** CharacterStatus */
    CharacterStatus: {
      character: components["schemas"]["Character"];
      /** Isk */
      isk?: number | null;
      /** Sp */
      sp?: number | null;
      /** Location */
      location?: string | null;
      /** Ship */
      ship?: string | null;
      /** Ship Name */
      ship_name?: string | null;
      /** Active */
      active: boolean;
      /** Last Logoff */
      last_logoff?: string | null;
      /** Last Login */
      last_login?: string | null;
      /** Total Logins */
      total_logins?: number | null;
      /** Last Updates */
      last_updates?: Record<string, never> | null;
    };
    /** CharacterRoles */
    CharacterRoles: {
      character: components["schemas"]["Character"];
      /** Director */
      director: boolean;
      /** Station Manager */
      station_manager: boolean;
      /** Personnel Manager */
      personnel_manager: boolean;
      /** Accountant */
      accountant: boolean;
      /** Titles */
      titles?: components["schemas"]["EveName"][] | null;
    };
    /** CharacterSkills */
    CharacterSkills: {
      character: components["schemas"]["Character"];
      /** Skills */
      skills?: components["schemas"]["Skill"][] | null;
      /** Total Sp */
      total_sp: number;
      /** Unallocated Sp */
      unallocated_sp: number;
    };
    /** Skill */
    Skill: {
      /** Group */
      group: string;
      /** Skill */
      skill: string;
      /** Sp */
      sp: number;
      /** Level */
      level: number;
      /** Active */
      active: number;
    };
    /** CharacterSkillHistory */
    CharacterSkillHistory: {
      character: components["schemas"]["Character"];
      /** History */
      history?: components["schemas"]["SkillHistory"][] | null;
    };
    /** SkillHistory */
    SkillHistory: {
      /**
       * Date
       * Format: date-time
       */
      date: string;
      /** Total Sp */
      total_sp: number;
      /** Unallocated Sp */
      unallocated_sp: number;
      /** Sp */
      sp: number;
    };
    /** CharacterQueue */
    CharacterQueue: {
      character: components["schemas"]["Character"];
      /** Queue */
      queue?: components["schemas"]["CharacterQueueItem"][] | null;
    };
    /** CharacterQueueItem */
    CharacterQueueItem: {
      /** Skill */
      skill: string;
      /** Group */
      group: string;
      /** End Level */
      end_level: number;
      /** Position */
      position: number;
      /**
       * Current Level
       * @default 0
       */
      current_level: number | null;
      /**
       * Current Sp
       * @default 0
       */
      current_sp: number | null;
      /** Start Sp */
      start_sp: number;
      /** End Sp */
      end_sp: number;
      /** Start */
      start?: string | null;
      /** End */
      end?: string | null;
    };
    /** CharacterDoctrines */
    CharacterDoctrines: {
      character: components["schemas"]["Character"];
      /** Doctrines */
      doctrines: Record<string, never>;
      /** Skills */
      skills: Record<string, never>;
    };
    /** CharacterHistory */
    CharacterHistory: {
      character: components["schemas"]["Character"];
      /** History */
      history?: components["schemas"]["CorpHistory"][];
    };
    /** CorpHistory */
    CorpHistory: {
      /**
       * Start
       * Format: date-time
       */
      start: string;
      corporation: components["schemas"]["Corporation"];
    };
    /** Corporation */
    Corporation: {
      /** Corporation Id */
      corporation_id: number;
      /** Corporation Name */
      corporation_name: string;
      /** Alliance Id */
      alliance_id?: number | null;
      /** Alliance Name */
      alliance_name?: string | null;
    };
    /** Message */
    Message: {
      /** Message */
      message: string;
    };
    /** AssetItem */
    AssetItem: {
      /** Id */
      id: number;
      item: components["schemas"]["EveName"];
      /**
       * Quantity
       * @default 0
       */
      quantity: number;
      location?: components["schemas"]["EveLocation"] | null;
      /** Expand */
      expand?: boolean | null;
    };
    /** CorporationWalletEvent */
    CorporationWalletEvent: {
      /** Division */
      division: string;
      /** Id */
      id: number;
      /**
       * Date
       * Format: date-time
       */
      date: string;
      first_party: components["schemas"]["EveName"];
      second_party: components["schemas"]["EveName"];
      /** Ref Type */
      ref_type: string;
      /** Balance */
      balance: number;
      /** Amount */
      amount: number;
      /** Reason */
      reason?: string | null;
    };
    /** CorpStatus */
    CorpStatus: {
      corporation: components["schemas"]["Corporation"];
      /** Characters */
      characters: number;
      /** Active */
      active: boolean;
      /** Last Updates */
      last_updates?: Record<string, never> | null;
    };
    /** Metenox */
    Metenox: {
      structure: components["schemas"]["Structure"];
      /** Contents */
      contents: components["schemas"]["OreValue"][];
      /** Total */
      total: number;
    };
    /** OreValue */
    OreValue: {
      type: components["schemas"]["EveName"];
      /** Quantity */
      quantity: number;
      /** Value */
      value: number;
    };
    /** Structure */
    Structure: {
      /** Id */
      id: number;
      owner: components["schemas"]["Corporation"];
      /** Name */
      name: string;
      type: components["schemas"]["EveName"];
      /** Services */
      services?: components["schemas"]["StructureService"][] | null;
      location: components["schemas"]["EveName"];
      constellation?: components["schemas"]["EveName"] | null;
      region?: components["schemas"]["EveName"] | null;
      /** Celestial */
      celestial?: string | null;
      /** Fuel Expiry */
      fuel_expiry?: string | null;
      /** State */
      state?: string;
      /** State Expiry */
      state_expiry?: string | null;
    };
    /** StructureService */
    StructureService: {
      /** Name */
      name: string;
      /** State */
      state: string;
    };
    /** PingStats */
    PingStats: {
      /** Members */
      members: number;
      /** Structures */
      structures?: string[];
    };
  };
  responses: never;
  parameters: never;
  requestBodies: never;
  headers: never;
  pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
  corptools_api_core_menu_get_character_menu: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["MenuCategory"][];
        };
      };
    };
  };
  corptools_api_core_search_get_system_search: {
    parameters: {
      query?: {
        limit?: number;
      };
      header?: never;
      path: {
        search_text: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["EveName"][];
        };
      };
    };
  };
  corptools_api_core_search_get_location_search: {
    parameters: {
      query?: {
        limit?: number;
      };
      header?: never;
      path: {
        search_text: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["EveName"][];
        };
      };
    };
  };
  corptools_api_core_search_get_group_search: {
    parameters: {
      query?: {
        limit?: number;
      };
      header?: never;
      path: {
        search_text: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["EveName"][];
        };
      };
    };
  };
  corptools_api_character_assets_get_character_asset_locations: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["ValueLabel"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_assets_get_character_asset_list: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
        location_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterAssetItem"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_assets_get_character_asset_contents: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
        item_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterAssetItem"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_assets_get_character_asset_groups: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
        location_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterAssetGroups"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_clones_get_character_clones: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterClones"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_finances_get_character_wallet: {
    parameters: {
      query?: {
        limit?: number;
        offset?: number;
      };
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["PagedCharacterWalletEvent"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_finances_get_character_orders: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterOrder"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_finances_get_character_market: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterMarket"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_finances_get_character_wallet_activity: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_character_finances_get_character_contracts: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterContract"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_finances_get_character_loyalty_Points: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["LoyaltyPoints"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_interactions_get_character_contacts: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Contact"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_interactions_get_character_mail: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_interactions_get_mail_message_request: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
        mail_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_interactions_get_character_notifications: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterNotification"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_list_get_account_list: {
    parameters: {
      query?: {
        orphans?: boolean;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["AccountStatus"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_mining_get_all_characters_character_mining: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_mining_get_character_mining: {
    parameters: {
      query?: {
        look_back?: number | null;
      };
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: {
      content: {
        "application/json": number[] | null;
      };
    };
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_roles_get_character_roles: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterRoles"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_skills_get_character_skills: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterSkills"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_skills_get_character_skill_history: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterSkillHistory"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_skills_get_character_skillqueues: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterQueue"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_skills_get_character_doctrines: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterDoctrines"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_status_get_character_status: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["AccountStatus"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_status_get_qs_test: {
    parameters: {
      query?: {
        total?: number;
      };
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_character_status_get_character_pubdata: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterHistory"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_refresh_post_characters_refresh: {
    parameters: {
      query: {
        character_id: number;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_refresh_post_account_refresh: {
    parameters: {
      query: {
        character_id: number;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_at_a_glance_get_glance_assets: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_at_a_glance_get_glance_activities: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_at_a_glance_get_glance_ratting_counts: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_character_at_a_glance_get_glance_factions: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        character_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_assets_get_corporation_asset_locations: {
    parameters: {
      query?: {
        top_level_only?: boolean;
      };
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["ValueLabel"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
    };
  };
  corptools_api_corporation_assets_get_corporation_asset_list: {
    parameters: {
      query?: {
        new_asset_tree?: boolean;
      };
      header?: never;
      path: {
        corporation_id: number;
        location_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["AssetItem"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
    };
  };
  corptools_api_corporation_assets_get_corporation_asset_contents: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        item_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["AssetItem"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
    };
  };
  corptools_api_corporation_assets_get_corporation_asset_groups: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
        location_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CharacterAssetGroups"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
    };
  };
  corptools_api_corporation_finances_get_corporation_wallet_types: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_corporation_finances_get_corporation_wallet: {
    parameters: {
      query?: {
        type_refs?: string;
        page?: number;
      };
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CorporationWalletEvent"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_finances_get_corporation_divisions: {
    parameters: {
      query?: {
        type_refs?: string;
        page?: number;
      };
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_list_get_visible_corporation_status: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CorpStatus"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_status_get_corporation_status: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["CorpStatus"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_status_get_corporation_character_status: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_dashboards_get_dashboard_gates: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
    };
  };
  corptools_api_corporation_dashboards_get_dashboard_sov: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_dashboards_get_dashboard_drills: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Metenox"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_dashboards_get_visible_dens: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_visible_structures: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Structure"][];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_fuel_data: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_corporation_structure_fitting: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        structure_id: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Not Found */
      404: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_visible_pocos: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_jb_link: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_visible_starbases: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": unknown[];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_structures_get_visible_starbase_fit: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        starbase_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_at_a_glance_get_glance_assets_corp: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_at_a_glance_get_glance_activities_pve: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_at_a_glance_get_glance_activities_indy: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_at_a_glance_get_glance_activities: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_at_a_glance_get_glance_factions: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_corporation_mining_get_corporation_agregated_mining: {
    parameters: {
      query?: {
        look_back?: number | null;
      };
      header?: never;
      path: {
        corporation_id: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_fittings_get_fit_skills: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        fit_id: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Not Found */
      404: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Internal Server Error */
      500: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_fittings_get_dogma: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        type_id: string;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Not Found */
      404: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Internal Server Error */
      500: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_asset_pinger_post_send_pings_assets: {
    parameters: {
      query: {
        message: string;
        systems?: string;
        structures?: string;
        ignore_groups?: string;
        filter_charges?: boolean;
        ships_only?: boolean;
        capitals_only?: boolean;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["Message"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_asset_pinger_post_test_pings_assets: {
    parameters: {
      query?: {
        systems?: string;
        structures?: string;
        ignore_groups?: string;
        filter_charges?: boolean;
        ships_only?: boolean;
        capitals_only?: boolean;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": components["schemas"]["PingStats"];
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_clone_deaths_get_dead_clones_in_location: {
    parameters: {
      query?: never;
      header?: never;
      path: {
        location_id: number;
        look_back: number;
      };
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": Record<string, never>;
        };
      };
      /** @description Forbidden */
      403: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Not Found */
      404: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
      /** @description Internal Server Error */
      500: {
        headers: {
          [name: string]: unknown;
        };
        content: {
          "application/json": string;
        };
      };
    };
  };
  corptools_api_extras_testing_get_test_api_bravadosih: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_extras_testing_get_test_api_openapi: {
    parameters: {
      query?: never;
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_extras_testing_get_test_api_openapi_3: {
    parameters: {
      query?: {
        name?: string;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
  corptools_api_extras_testing_get_test_api_openapi_4: {
    parameters: {
      query?: {
        character_id?: number;
      };
      header?: never;
      path?: never;
      cookie?: never;
    };
    requestBody?: never;
    responses: {
      /** @description OK */
      200: {
        headers: {
          [name: string]: unknown;
        };
        content?: never;
      };
    };
  };
}
