# Generated by Django 3.2.8 on 2022-01-09 10:19

from django.db import migrations
from django.db.models import F

from corptools.models import NotificationText


def migrate_notifications(apps, schema_editor):
    Notification = apps.get_model('corptools', 'Notification')
    cnt = Notification.objects.filter(note_text__isnull=True).count()
    print("")
    print(f"Starting Sync {cnt} to sync")
    while cnt > 0:
        n = list(Notification.objects.filter(
            note_text__isnull=True).values_list('pk', flat=True)[:50000])
        nc = Notification.objects.filter(pk__in=n).update(
            note_text_id=F("notification_id"))
        cnt = Notification.objects.filter(note_text__isnull=True).count()
        print(f"synced {nc}. {cnt} remaining")


class Migration(migrations.Migration):
    atomic = False
    dependencies = [
        ('corptools', '0064_notification_note_text'),
    ]

    operations = [
        migrations.RunPython(migrate_notifications)
    ]
