# Generated by Django 3.2.5 on 2021-08-08 03:49

import django.db.models.deletion
from django.db import migrations, models
from django.db.models import Count


def remove_dupes(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    CharacterRoles = apps.get_model('corptools', 'CharacterRoles')
    ids = CharacterRoles.objects.values('character').annotate(
        Count('id')).order_by().filter(id__count__gt=1)
    for id in ids:
        _id = CharacterRoles.objects.filter(
            character_id=id['character']).last().pk
        CharacterRoles.objects.filter(
            character_id=id['character']).exclude(pk=_id).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('corptools', '0054_auto_20210808_0138'),
    ]

    operations = [
        migrations.RunPython(remove_dupes),
        migrations.AlterField(
            model_name='characterroles',
            name='character',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, to='corptools.characteraudit'),
        ),
    ]
