# This file was auto-generated by Fern from our API Definition.

from .invoice_webhook import InvoiceWebhook
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class InvoiceStatusChangedWebhook(InvoiceWebhook):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        CounterpartyCustomizationAccount,
        CounterpartyResponse,
        Ein,
        EntityUserResponse,
        ProfileResponse,
        TaxId,
    )
    from mercoa.invoice_types import InvoiceResponse
    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
    from mercoa.webhooks import InvoiceStatusChangedWebhook

    InvoiceStatusChangedWebhook(
        event_type="invoice.status.changed",
        invoice=InvoiceResponse(
            id="in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9",
            status="NEW",
            payer_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payer=CounterpartyResponse(
                id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                foreign_id="MY-DB-ID-12345",
                name="Acme Inc.",
                email="customer@acme.com",
                accepted_tos=True,
                status="verified",
                is_customer=True,
                is_payor=True,
                is_payee=False,
                is_network_payor=False,
                is_network_payee=False,
                account_type="business",
                updated_at=datetime.datetime.fromisoformat(
                    "2024-01-02 00:00:00+00:00",
                ),
                created_at=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
                profile=ProfileResponse(
                    business=BusinessProfileResponse(
                        email="customer@acme.com",
                        legal_business_name="Acme Inc.",
                        business_type="llc",
                        phone=PhoneNumber(
                            country_code="1",
                            number="4155551234",
                        ),
                        address=Address(
                            address_line_1="123 Main St",
                            address_line_2="Unit 1",
                            city="San Francisco",
                            state_or_province="CA",
                            postal_code="94105",
                            country="US",
                        ),
                        tax_id_provided=True,
                        tax_id=TaxId(
                            ein=Ein(
                                number="12-3456789",
                            ),
                        ),
                        owners_provided=True,
                    ),
                ),
                accounts=[
                    CounterpartyCustomizationAccount(
                        account_id="85866843",
                        postal_code="94105",
                        name_on_account="John Doe",
                    )
                ],
                payment_methods=[
                    PaymentMethodResponse_BankAccount(
                        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                        account_name="My Checking Account",
                        bank_name="Chase",
                        routing_number="12345678",
                        account_number="99988767623",
                        account_type="CHECKING",
                        status="VERIFIED",
                        is_default_source=True,
                        is_default_destination=True,
                        supported_currencies=["USD"],
                        metadata={},
                        frozen=False,
                        created_at=datetime.datetime.fromisoformat(
                            "2021-01-01 00:00:00+00:00",
                        ),
                        updated_at=datetime.datetime.fromisoformat(
                            "2021-01-01 00:00:00+00:00",
                        ),
                    )
                ],
                counterparty_type=["ENTITY"],
            ),
            vendor_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            vendor=CounterpartyResponse(
                id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                foreign_id="MY-DB-ID-90909",
                name="Big Box Store",
                email="vendor@bigboxstore.com",
                accepted_tos=False,
                status="unverified",
                is_customer=False,
                is_payor=False,
                is_payee=True,
                is_network_payor=False,
                is_network_payee=False,
                account_type="business",
                updated_at=datetime.datetime.fromisoformat(
                    "2024-01-02 00:00:00+00:00",
                ),
                created_at=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
                profile=ProfileResponse(
                    business=BusinessProfileResponse(
                        email="vendor@bigboxstore.com",
                        legal_business_name="Big Box Store",
                        business_type="publicCorporation",
                        tax_id_provided=False,
                        owners_provided=False,
                    ),
                ),
                payment_methods=[
                    PaymentMethodResponse_BankAccount(
                        id="pm_7610541f-4619-4033-8620-cfccfb811293",
                        account_name="Vendor Checking Account",
                        bank_name="Chase",
                        routing_number="66554433",
                        account_number="55934059697648",
                        account_type="CHECKING",
                        status="NEW",
                        is_default_source=True,
                        is_default_destination=True,
                        supported_currencies=["USD"],
                        metadata={},
                        frozen=False,
                        created_at=datetime.datetime.fromisoformat(
                            "2021-01-01 00:00:00+00:00",
                        ),
                        updated_at=datetime.datetime.fromisoformat(
                            "2021-01-01 00:00:00+00:00",
                        ),
                    )
                ],
                counterparty_type=["ENTITY"],
            ),
            currency="USD",
            amount=100.0,
            invoice_number="INV-123",
            invoice_date=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            due_date=datetime.datetime.fromisoformat(
                "2021-01-31 00:00:00+00:00",
            ),
            payment_source_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            payment_source=PaymentMethodResponse_BankAccount(
                id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                account_name="My Checking Account",
                bank_name="Chase",
                routing_number="12345678",
                account_number="99988767623",
                account_type="CHECKING",
                status="VERIFIED",
                is_default_source=True,
                is_default_destination=True,
                supported_currencies=["USD"],
                metadata={},
                frozen=False,
                created_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
                updated_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
            ),
            payment_destination_confirmed=True,
            has_documents=True,
            has_source_email=True,
            approvers=[],
            approval_policy=[],
            metadata={},
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        new_status="new",
        previous_status="draft",
        user=EntityUserResponse(
            id="user_ec3aafc8-ea86-408a-a6c1-545497badbbb",
            foreign_id="MY-DB-ID-12345",
            email="john.doe@acme.com",
            name="John Doe",
            roles=["admin", "approver"],
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
        ),
    )
    """

    new_status: str = pydantic.Field(alias="newStatus")
    previous_status: str = pydantic.Field(alias="previousStatus")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
