# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.entity_user_response import EntityUserResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CounterpartyWebhook(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_types import EntityUserResponse
    from mercoa.webhooks import CounterpartyWebhook

    CounterpartyWebhook(
        event_type="counterparty.added",
        payee_id=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
        payor_id=["ent_8545a84e-a45f-41bf-bdf1-33b42a55812c"],
        user=EntityUserResponse(
            id="user_ec3aafc8-ea86-408a-a6c1-545497badbbb",
            foreign_id="MY-DB-ID-12345",
            email="john.doe@acme.com",
            name="John Doe",
            roles=["admin", "approver"],
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
        ),
    )
    """

    event_type: str = pydantic.Field(alias="eventType")
    payee_id: typing.List[EntityId] = pydantic.Field(alias="payeeId")
    payor_id: typing.List[EntityId] = pydantic.Field(alias="payorId")
    user: typing.Optional[EntityUserResponse] = pydantic.Field(default=None)
    """
    User who initiated the change.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
