# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .vendor_credit_id import VendorCreditId
import typing
import pydantic
from ...payment_method_types.types.currency_code import CurrencyCode
from ...entity_types.types.entity_id import EntityId
from ...invoice_types.types.invoice_id import InvoiceId
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class VendorCreditResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.vendor_credit_types import VendorCreditResponse

    VendorCreditResponse(
        id="vcr_c3f4c87d-794d-4543-9562-575cdddfc0d7",
        total_amount=100.0,
        remaining_amount=100.0,
        currency="USD",
        vendor_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        payer_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
        creator_entity_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        note="This is a note",
        invoice_ids=["in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9"],
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    id: VendorCreditId
    total_amount: typing.Optional[float] = pydantic.Field(alias="totalAmount", default=None)
    """
    Total issued amount of the vendor credit in major units
    """

    remaining_amount: typing.Optional[float] = pydantic.Field(alias="remainingAmount", default=None)
    """
    Remaining usable amount in the vendor credit in major units
    """

    currency: typing.Optional[CurrencyCode] = pydantic.Field(default=None)
    """
    Currency code for the amount. Defaults to USD.
    """

    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    """
    ID of the vendor the vendor credit may be used for
    """

    payer_id: EntityId = pydantic.Field(alias="payerId")
    """
    ID of the payer who may use the vendor credit
    """

    creator_entity_id: typing.Optional[EntityId] = pydantic.Field(alias="creatorEntityId", default=None)
    """
    ID of the entity that created this vendor credit
    """

    note: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional note to attach to the vendor credit
    """

    invoice_ids: typing.Optional[typing.List[InvoiceId]] = pydantic.Field(alias="invoiceIds", default=None)
    """
    The IDs of the invoices that this vendor credit has been applied to
    """

    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
