# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
from ...payment_method_types.types.currency_code import CurrencyCode
import typing
from .vendor_credit_response import VendorCreditResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CalculateVendorCreditUsageResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.vendor_credit_types import (
        CalculateVendorCreditUsageResponse,
        VendorCreditResponse,
    )

    CalculateVendorCreditUsageResponse(
        remaining_amount=50.0,
        currency="USD",
        vendor_credits=[
            VendorCreditResponse(
                id="vcr_c3f4c87d-794d-4543-9562-575cdddfc0d7",
                total_amount=100.0,
                remaining_amount=0.0,
                currency="USD",
                vendor_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                payer_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                creator_entity_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                note="This is a note",
                invoice_ids=["in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9"],
                created_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
                updated_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
            )
        ],
    )
    """

    remaining_amount: float = pydantic.Field(alias="remainingAmount")
    """
    Remaining amount on the invoice after vendor credits are applied in major units.
    """

    currency: CurrencyCode = pydantic.Field()
    """
    Currency code for the amount. Defaults to USD.
    """

    vendor_credits: typing.List[VendorCreditResponse] = pydantic.Field(alias="vendorCredits")
    """
    Vendor credits that will be applied to the invoice. The objects returned represent the states each vendor credit will be in AFTER they are applied to the invoice, not their current states.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
