# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
from .transaction_failure_reason import TransactionFailureReason
import pydantic
from .transaction_id import TransactionId
from .transaction_status import TransactionStatus
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.counterparty_response import CounterpartyResponse
from ...payment_method_types.types.payment_method_response import PaymentMethodResponse
from ...payment_method_types.types.payment_method_id import PaymentMethodId
from ...invoice_types.types.payment_destination_options import PaymentDestinationOptions
from ...invoice_types.types.invoice_fees_response import InvoiceFeesResponse
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TransactionResponseWithoutInvoices_BankAccountToBankAccount(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        CounterpartyCustomizationAccount,
        CounterpartyResponse,
        Ein,
        ProfileResponse,
        TaxId,
    )
    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
    from mercoa.transaction import (
        TransactionResponseWithoutInvoices_BankAccountToBankAccount,
    )

    TransactionResponseWithoutInvoices_BankAccountToBankAccount(
        id="trx_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        status="PENDING",
        amount=10000,
        currency="USD",
        payer_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        payer=CounterpartyResponse(
            id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            foreign_id="MY-DB-ID-12345",
            name="Acme Inc.",
            email="customer@acme.com",
            accepted_tos=True,
            status="verified",
            is_customer=True,
            is_payor=True,
            is_payee=False,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="customer@acme.com",
                    legal_business_name="Acme Inc.",
                    business_type="llc",
                    phone=PhoneNumber(
                        country_code="1",
                        number="4155551234",
                    ),
                    address=Address(
                        address_line_1="123 Main St",
                        address_line_2="Unit 1",
                        city="San Francisco",
                        state_or_province="CA",
                        postal_code="94105",
                        country="US",
                    ),
                    tax_id_provided=True,
                    tax_id=TaxId(
                        ein=Ein(
                            number="12-3456789",
                        ),
                    ),
                    owners_provided=True,
                ),
            ),
            accounts=[
                CounterpartyCustomizationAccount(
                    account_id="85866843",
                    postal_code="94105",
                    name_on_account="John Doe",
                )
            ],
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                    account_name="My Checking Account",
                    bank_name="Chase",
                    routing_number="12345678",
                    account_number="99988767623",
                    account_type="CHECKING",
                    status="VERIFIED",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_source=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_source_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        vendor_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        vendor=CounterpartyResponse(
            id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            foreign_id="MY-DB-ID-90909",
            name="Big Box Store",
            email="vendor@bigboxstore.com",
            accepted_tos=False,
            status="unverified",
            is_customer=False,
            is_payor=False,
            is_payee=True,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="vendor@bigboxstore.com",
                    legal_business_name="Big Box Store",
                    business_type="publicCorporation",
                    tax_id_provided=False,
                    owners_provided=False,
                ),
            ),
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_7610541f-4619-4033-8620-cfccfb811293",
                    account_name="Vendor Checking Account",
                    bank_name="Chase",
                    routing_number="66554433",
                    account_number="55934059697648",
                    account_type="CHECKING",
                    status="NEW",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_destination=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_destination_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["bankAccountToBankAccount"] = "bankAccountToBankAccount"
    failure_reason: typing.Optional[TransactionFailureReason] = pydantic.Field(alias="failureReason", default=None)
    id: TransactionId
    status: TransactionStatus
    amount: int
    currency: str
    payer_id: EntityId = pydantic.Field(alias="payerId")
    payer: CounterpartyResponse
    payment_source: PaymentMethodResponse = pydantic.Field(alias="paymentSource")
    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    vendor: CounterpartyResponse
    payment_destination: PaymentMethodResponse = pydantic.Field(alias="paymentDestination")
    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    fees: typing.Optional[InvoiceFeesResponse] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class TransactionResponseWithoutInvoices_BankAccountToMailedCheck(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        CounterpartyCustomizationAccount,
        CounterpartyResponse,
        Ein,
        ProfileResponse,
        TaxId,
    )
    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
    from mercoa.transaction import (
        TransactionResponseWithoutInvoices_BankAccountToBankAccount,
    )

    TransactionResponseWithoutInvoices_BankAccountToBankAccount(
        id="trx_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        status="PENDING",
        amount=10000,
        currency="USD",
        payer_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        payer=CounterpartyResponse(
            id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            foreign_id="MY-DB-ID-12345",
            name="Acme Inc.",
            email="customer@acme.com",
            accepted_tos=True,
            status="verified",
            is_customer=True,
            is_payor=True,
            is_payee=False,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="customer@acme.com",
                    legal_business_name="Acme Inc.",
                    business_type="llc",
                    phone=PhoneNumber(
                        country_code="1",
                        number="4155551234",
                    ),
                    address=Address(
                        address_line_1="123 Main St",
                        address_line_2="Unit 1",
                        city="San Francisco",
                        state_or_province="CA",
                        postal_code="94105",
                        country="US",
                    ),
                    tax_id_provided=True,
                    tax_id=TaxId(
                        ein=Ein(
                            number="12-3456789",
                        ),
                    ),
                    owners_provided=True,
                ),
            ),
            accounts=[
                CounterpartyCustomizationAccount(
                    account_id="85866843",
                    postal_code="94105",
                    name_on_account="John Doe",
                )
            ],
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                    account_name="My Checking Account",
                    bank_name="Chase",
                    routing_number="12345678",
                    account_number="99988767623",
                    account_type="CHECKING",
                    status="VERIFIED",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_source=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_source_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        vendor_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        vendor=CounterpartyResponse(
            id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            foreign_id="MY-DB-ID-90909",
            name="Big Box Store",
            email="vendor@bigboxstore.com",
            accepted_tos=False,
            status="unverified",
            is_customer=False,
            is_payor=False,
            is_payee=True,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="vendor@bigboxstore.com",
                    legal_business_name="Big Box Store",
                    business_type="publicCorporation",
                    tax_id_provided=False,
                    owners_provided=False,
                ),
            ),
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_7610541f-4619-4033-8620-cfccfb811293",
                    account_name="Vendor Checking Account",
                    bank_name="Chase",
                    routing_number="66554433",
                    account_number="55934059697648",
                    account_type="CHECKING",
                    status="NEW",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_destination=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_destination_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["bankAccountToMailedCheck"] = "bankAccountToMailedCheck"
    check_number: int = pydantic.Field(alias="checkNumber")
    id: TransactionId
    status: TransactionStatus
    amount: int
    currency: str
    payer_id: EntityId = pydantic.Field(alias="payerId")
    payer: CounterpartyResponse
    payment_source: PaymentMethodResponse = pydantic.Field(alias="paymentSource")
    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    vendor: CounterpartyResponse
    payment_destination: PaymentMethodResponse = pydantic.Field(alias="paymentDestination")
    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    fees: typing.Optional[InvoiceFeesResponse] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class TransactionResponseWithoutInvoices_Custom(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        CounterpartyCustomizationAccount,
        CounterpartyResponse,
        Ein,
        ProfileResponse,
        TaxId,
    )
    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
    from mercoa.transaction import (
        TransactionResponseWithoutInvoices_BankAccountToBankAccount,
    )

    TransactionResponseWithoutInvoices_BankAccountToBankAccount(
        id="trx_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        status="PENDING",
        amount=10000,
        currency="USD",
        payer_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        payer=CounterpartyResponse(
            id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            foreign_id="MY-DB-ID-12345",
            name="Acme Inc.",
            email="customer@acme.com",
            accepted_tos=True,
            status="verified",
            is_customer=True,
            is_payor=True,
            is_payee=False,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="customer@acme.com",
                    legal_business_name="Acme Inc.",
                    business_type="llc",
                    phone=PhoneNumber(
                        country_code="1",
                        number="4155551234",
                    ),
                    address=Address(
                        address_line_1="123 Main St",
                        address_line_2="Unit 1",
                        city="San Francisco",
                        state_or_province="CA",
                        postal_code="94105",
                        country="US",
                    ),
                    tax_id_provided=True,
                    tax_id=TaxId(
                        ein=Ein(
                            number="12-3456789",
                        ),
                    ),
                    owners_provided=True,
                ),
            ),
            accounts=[
                CounterpartyCustomizationAccount(
                    account_id="85866843",
                    postal_code="94105",
                    name_on_account="John Doe",
                )
            ],
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                    account_name="My Checking Account",
                    bank_name="Chase",
                    routing_number="12345678",
                    account_number="99988767623",
                    account_type="CHECKING",
                    status="VERIFIED",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_source=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_source_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        vendor_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        vendor=CounterpartyResponse(
            id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            foreign_id="MY-DB-ID-90909",
            name="Big Box Store",
            email="vendor@bigboxstore.com",
            accepted_tos=False,
            status="unverified",
            is_customer=False,
            is_payor=False,
            is_payee=True,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="vendor@bigboxstore.com",
                    legal_business_name="Big Box Store",
                    business_type="publicCorporation",
                    tax_id_provided=False,
                    owners_provided=False,
                ),
            ),
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_7610541f-4619-4033-8620-cfccfb811293",
                    account_name="Vendor Checking Account",
                    bank_name="Chase",
                    routing_number="66554433",
                    account_number="55934059697648",
                    account_type="CHECKING",
                    status="NEW",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_destination=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_destination_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["custom"] = "custom"
    id: TransactionId
    status: TransactionStatus
    amount: int
    currency: str
    payer_id: EntityId = pydantic.Field(alias="payerId")
    payer: CounterpartyResponse
    payment_source: PaymentMethodResponse = pydantic.Field(alias="paymentSource")
    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    vendor: CounterpartyResponse
    payment_destination: PaymentMethodResponse = pydantic.Field(alias="paymentDestination")
    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    fees: typing.Optional[InvoiceFeesResponse] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class TransactionResponseWithoutInvoices_OffPlatform(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        CounterpartyCustomizationAccount,
        CounterpartyResponse,
        Ein,
        ProfileResponse,
        TaxId,
    )
    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
    from mercoa.transaction import (
        TransactionResponseWithoutInvoices_BankAccountToBankAccount,
    )

    TransactionResponseWithoutInvoices_BankAccountToBankAccount(
        id="trx_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        status="PENDING",
        amount=10000,
        currency="USD",
        payer_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        payer=CounterpartyResponse(
            id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            foreign_id="MY-DB-ID-12345",
            name="Acme Inc.",
            email="customer@acme.com",
            accepted_tos=True,
            status="verified",
            is_customer=True,
            is_payor=True,
            is_payee=False,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="customer@acme.com",
                    legal_business_name="Acme Inc.",
                    business_type="llc",
                    phone=PhoneNumber(
                        country_code="1",
                        number="4155551234",
                    ),
                    address=Address(
                        address_line_1="123 Main St",
                        address_line_2="Unit 1",
                        city="San Francisco",
                        state_or_province="CA",
                        postal_code="94105",
                        country="US",
                    ),
                    tax_id_provided=True,
                    tax_id=TaxId(
                        ein=Ein(
                            number="12-3456789",
                        ),
                    ),
                    owners_provided=True,
                ),
            ),
            accounts=[
                CounterpartyCustomizationAccount(
                    account_id="85866843",
                    postal_code="94105",
                    name_on_account="John Doe",
                )
            ],
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                    account_name="My Checking Account",
                    bank_name="Chase",
                    routing_number="12345678",
                    account_number="99988767623",
                    account_type="CHECKING",
                    status="VERIFIED",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_source=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_source_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        vendor_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
        vendor=CounterpartyResponse(
            id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            foreign_id="MY-DB-ID-90909",
            name="Big Box Store",
            email="vendor@bigboxstore.com",
            accepted_tos=False,
            status="unverified",
            is_customer=False,
            is_payor=False,
            is_payee=True,
            is_network_payor=False,
            is_network_payee=False,
            account_type="business",
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-02 00:00:00+00:00",
            ),
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            profile=ProfileResponse(
                business=BusinessProfileResponse(
                    email="vendor@bigboxstore.com",
                    legal_business_name="Big Box Store",
                    business_type="publicCorporation",
                    tax_id_provided=False,
                    owners_provided=False,
                ),
            ),
            payment_methods=[
                PaymentMethodResponse_BankAccount(
                    id="pm_7610541f-4619-4033-8620-cfccfb811293",
                    account_name="Vendor Checking Account",
                    bank_name="Chase",
                    routing_number="66554433",
                    account_number="55934059697648",
                    account_type="CHECKING",
                    status="NEW",
                    is_default_source=True,
                    is_default_destination=True,
                    supported_currencies=["USD"],
                    metadata={},
                    frozen=False,
                    created_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                    updated_at=datetime.datetime.fromisoformat(
                        "2021-01-01 00:00:00+00:00",
                    ),
                )
            ],
            counterparty_type=["ENTITY"],
        ),
        payment_destination=PaymentMethodResponse_BankAccount(
            id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            account_name="My Checking Account",
            bank_name="Chase",
            routing_number="12345678",
            account_number="99988767623",
            account_type="CHECKING",
            status="VERIFIED",
            is_default_source=True,
            is_default_destination=True,
            supported_currencies=["USD"],
            metadata={},
            frozen=False,
            created_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2021-01-01 00:00:00+00:00",
            ),
        ),
        payment_destination_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["offPlatform"] = "offPlatform"
    id: TransactionId
    status: TransactionStatus
    amount: int
    currency: str
    payer_id: EntityId = pydantic.Field(alias="payerId")
    payer: CounterpartyResponse
    payment_source: PaymentMethodResponse = pydantic.Field(alias="paymentSource")
    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    vendor: CounterpartyResponse
    payment_destination: PaymentMethodResponse = pydantic.Field(alias="paymentDestination")
    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    fees: typing.Optional[InvoiceFeesResponse] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


"""
import datetime

from mercoa.commons import Address, PhoneNumber
from mercoa.entity_types import (
    BusinessProfileResponse,
    CounterpartyCustomizationAccount,
    CounterpartyResponse,
    Ein,
    ProfileResponse,
    TaxId,
)
from mercoa.payment_method_types import PaymentMethodResponse_BankAccount
from mercoa.transaction import (
    TransactionResponseWithoutInvoices_BankAccountToBankAccount,
)

TransactionResponseWithoutInvoices_BankAccountToBankAccount(
    id="trx_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
    status="PENDING",
    amount=10000,
    currency="USD",
    payer_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
    payer=CounterpartyResponse(
        id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
        foreign_id="MY-DB-ID-12345",
        name="Acme Inc.",
        email="customer@acme.com",
        accepted_tos=True,
        status="verified",
        is_customer=True,
        is_payor=True,
        is_payee=False,
        is_network_payor=False,
        is_network_payee=False,
        account_type="business",
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-02 00:00:00+00:00",
        ),
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        profile=ProfileResponse(
            business=BusinessProfileResponse(
                email="customer@acme.com",
                legal_business_name="Acme Inc.",
                business_type="llc",
                phone=PhoneNumber(
                    country_code="1",
                    number="4155551234",
                ),
                address=Address(
                    address_line_1="123 Main St",
                    address_line_2="Unit 1",
                    city="San Francisco",
                    state_or_province="CA",
                    postal_code="94105",
                    country="US",
                ),
                tax_id_provided=True,
                tax_id=TaxId(
                    ein=Ein(
                        number="12-3456789",
                    ),
                ),
                owners_provided=True,
            ),
        ),
        accounts=[
            CounterpartyCustomizationAccount(
                account_id="85866843",
                postal_code="94105",
                name_on_account="John Doe",
            )
        ],
        payment_methods=[
            PaymentMethodResponse_BankAccount(
                id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
                account_name="My Checking Account",
                bank_name="Chase",
                routing_number="12345678",
                account_number="99988767623",
                account_type="CHECKING",
                status="VERIFIED",
                is_default_source=True,
                is_default_destination=True,
                supported_currencies=["USD"],
                metadata={},
                frozen=False,
                created_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
                updated_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
            )
        ],
        counterparty_type=["ENTITY"],
    ),
    payment_source=PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    ),
    payment_source_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
    vendor_id="ent_bb08e72f-19f8-45f3-bcf9-46fdc46cb2f4",
    vendor=CounterpartyResponse(
        id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        foreign_id="MY-DB-ID-90909",
        name="Big Box Store",
        email="vendor@bigboxstore.com",
        accepted_tos=False,
        status="unverified",
        is_customer=False,
        is_payor=False,
        is_payee=True,
        is_network_payor=False,
        is_network_payee=False,
        account_type="business",
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-02 00:00:00+00:00",
        ),
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        profile=ProfileResponse(
            business=BusinessProfileResponse(
                email="vendor@bigboxstore.com",
                legal_business_name="Big Box Store",
                business_type="publicCorporation",
                tax_id_provided=False,
                owners_provided=False,
            ),
        ),
        payment_methods=[
            PaymentMethodResponse_BankAccount(
                id="pm_7610541f-4619-4033-8620-cfccfb811293",
                account_name="Vendor Checking Account",
                bank_name="Chase",
                routing_number="66554433",
                account_number="55934059697648",
                account_type="CHECKING",
                status="NEW",
                is_default_source=True,
                is_default_destination=True,
                supported_currencies=["USD"],
                metadata={},
                frozen=False,
                created_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
                updated_at=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
            )
        ],
        counterparty_type=["ENTITY"],
    ),
    payment_destination=PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    ),
    payment_destination_id="pm_65523ab0-043d-4706-b2b2-0b73fed92269",
    created_at=datetime.datetime.fromisoformat(
        "2024-01-01 00:00:00+00:00",
    ),
    updated_at=datetime.datetime.fromisoformat(
        "2024-01-01 00:00:00+00:00",
    ),
)
"""
TransactionResponseWithoutInvoices = typing.Union[
    TransactionResponseWithoutInvoices_BankAccountToBankAccount,
    TransactionResponseWithoutInvoices_BankAccountToMailedCheck,
    TransactionResponseWithoutInvoices_Custom,
    TransactionResponseWithoutInvoices_OffPlatform,
]
