# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .transaction_id import TransactionId
from .transaction_status import TransactionStatus
from ...entity_types.types.entity_id import EntityId
import pydantic
from ...entity_types.types.counterparty_response import CounterpartyResponse
from ...payment_method_types.types.payment_method_response import PaymentMethodResponse
from ...payment_method_types.types.payment_method_id import PaymentMethodId
import typing
from ...invoice_types.types.payment_destination_options import PaymentDestinationOptions
from ...invoice_types.types.invoice_fees_response import InvoiceFeesResponse
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TransactionResponseBase(UniversalBaseModel):
    id: TransactionId
    status: TransactionStatus
    amount: int
    currency: str
    payer_id: EntityId = pydantic.Field(alias="payerId")
    payer: CounterpartyResponse
    payment_source: PaymentMethodResponse = pydantic.Field(alias="paymentSource")
    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    vendor_id: EntityId = pydantic.Field(alias="vendorId")
    vendor: CounterpartyResponse
    payment_destination: PaymentMethodResponse = pydantic.Field(alias="paymentDestination")
    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    fees: typing.Optional[InvoiceFeesResponse] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
