# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..payment_method_types.types.payment_method_id import PaymentMethodId
from ..payment_method_types.types.payment_method_type import PaymentMethodType
from ..entity_types.types.entity_id import EntityId
from ..core.request_options import RequestOptions
from ..payment_method_types.types.payment_method_with_entity_find_response import PaymentMethodWithEntityFindResponse
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.pydantic_utilities import parse_obj_as
from ..commons.errors.bad_request import BadRequest
from ..commons.errors.unauthorized import Unauthorized
from ..commons.errors.forbidden import Forbidden
from ..commons.errors.not_found import NotFound
from ..commons.errors.conflict import Conflict
from ..commons.errors.internal_server_error import InternalServerError
from ..commons.errors.unimplemented import Unimplemented
from ..core.client_wrapper import AsyncClientWrapper


class PaymentMethodsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def find(
        self,
        *,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[PaymentMethodId] = None,
        type: typing.Optional[typing.Union[PaymentMethodType, typing.Sequence[PaymentMethodType]]] = None,
        entity_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentMethodWithEntityFindResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Number of payment methods to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[PaymentMethodId]
            The ID of the payment method to start after. If not provided, the first page of payment methods will be returned.

        type : typing.Optional[typing.Union[PaymentMethodType, typing.Sequence[PaymentMethodType]]]
            Type of payment method to filter

        entity_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Entity ID to filter

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentMethodWithEntityFindResponse

        Examples
        --------
        from mercoa import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.payment_methods.find()
        """
        _response = self._client_wrapper.httpx_client.request(
            "paymentMethods",
            method="GET",
            params={
                "limit": limit,
                "startingAfter": starting_after,
                "type": type,
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                PaymentMethodWithEntityFindResponse,
                parse_obj_as(
                    type_=PaymentMethodWithEntityFindResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncPaymentMethodsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def find(
        self,
        *,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[PaymentMethodId] = None,
        type: typing.Optional[typing.Union[PaymentMethodType, typing.Sequence[PaymentMethodType]]] = None,
        entity_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentMethodWithEntityFindResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Number of payment methods to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[PaymentMethodId]
            The ID of the payment method to start after. If not provided, the first page of payment methods will be returned.

        type : typing.Optional[typing.Union[PaymentMethodType, typing.Sequence[PaymentMethodType]]]
            Type of payment method to filter

        entity_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Entity ID to filter

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentMethodWithEntityFindResponse

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.payment_methods.find()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "paymentMethods",
            method="GET",
            params={
                "limit": limit,
                "startingAfter": starting_after,
                "type": type,
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                PaymentMethodWithEntityFindResponse,
                parse_obj_as(
                    type_=PaymentMethodWithEntityFindResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)
