# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .bank_type import BankType
from .bank_status import BankStatus
from .bank_account_check_options import BankAccountCheckOptions
from .payment_method_id import PaymentMethodId
from .currency_code import CurrencyCode
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .card_type import CardType
from .card_brand import CardBrand
from .custom_payment_method_schema_id import CustomPaymentMethodSchemaId
from .custom_payment_method_schema_response import CustomPaymentMethodSchemaResponse


class PaymentMethodResponse_BankAccount(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["bankAccount"] = "bankAccount"
    account_name: str = pydantic.Field(alias="accountName")
    bank_name: str = pydantic.Field(alias="bankName")
    routing_number: str = pydantic.Field(alias="routingNumber")
    account_number: str = pydantic.Field(alias="accountNumber")
    account_type: BankType = pydantic.Field(alias="accountType")
    status: BankStatus
    check_options: typing.Optional[BankAccountCheckOptions] = pydantic.Field(alias="checkOptions", default=None)
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodResponse_Card(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["card"] = "card"
    card_type: CardType = pydantic.Field(alias="cardType")
    card_brand: CardBrand = pydantic.Field(alias="cardBrand")
    last_four: str = pydantic.Field(alias="lastFour")
    exp_month: str = pydantic.Field(alias="expMonth")
    exp_year: str = pydantic.Field(alias="expYear")
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodResponse_Check(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["check"] = "check"
    pay_to_the_order_of: str = pydantic.Field(alias="payToTheOrderOf")
    address_line_1: str = pydantic.Field(alias="addressLine1")
    address_line_2: typing.Optional[str] = pydantic.Field(alias="addressLine2", default=None)
    city: str
    state_or_province: str = pydantic.Field(alias="stateOrProvince")
    postal_code: str = pydantic.Field(alias="postalCode")
    country: str
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodResponse_Custom(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["custom"] = "custom"
    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    account_name: typing.Optional[str] = pydantic.Field(alias="accountName", default=None)
    account_number: typing.Optional[str] = pydantic.Field(alias="accountNumber", default=None)
    available_balance: typing.Optional[float] = pydantic.Field(alias="availableBalance", default=None)
    schema_id: CustomPaymentMethodSchemaId = pydantic.Field(alias="schemaId")
    schema_: CustomPaymentMethodSchemaResponse = pydantic.Field(alias="schema")
    data: typing.Dict[str, str]
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodResponse_OffPlatform(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["offPlatform"] = "offPlatform"
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodResponse_Utility(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

    PaymentMethodResponse_BankAccount(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    type: typing.Literal["utility"] = "utility"
    utility_id: str = pydantic.Field(alias="utilityId")
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: bool
    metadata: typing.Dict[str, str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


"""
import datetime

from mercoa.payment_method_types import PaymentMethodResponse_BankAccount

PaymentMethodResponse_BankAccount(
    id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
    account_name="My Checking Account",
    bank_name="Chase",
    routing_number="12345678",
    account_number="99988767623",
    account_type="CHECKING",
    status="VERIFIED",
    is_default_source=True,
    is_default_destination=True,
    supported_currencies=["USD"],
    metadata={},
    frozen=False,
    created_at=datetime.datetime.fromisoformat(
        "2021-01-01 00:00:00+00:00",
    ),
    updated_at=datetime.datetime.fromisoformat(
        "2021-01-01 00:00:00+00:00",
    ),
)
"""
PaymentMethodResponse = typing.Union[
    PaymentMethodResponse_BankAccount,
    PaymentMethodResponse_Card,
    PaymentMethodResponse_Check,
    PaymentMethodResponse_Custom,
    PaymentMethodResponse_OffPlatform,
    PaymentMethodResponse_Utility,
]
