# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .bank_type import BankType
from .plaid_link_request import PlaidLinkRequest
from .bank_account_check_options import BankAccountCheckOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .card_type import CardType
from .card_brand import CardBrand
from .custom_payment_method_schema_id import CustomPaymentMethodSchemaId


class PaymentMethodRequest_BankAccount(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["bankAccount"] = "bankAccount"
    account_name: typing.Optional[str] = pydantic.Field(alias="accountName", default=None)
    bank_name: typing.Optional[str] = pydantic.Field(alias="bankName", default=None)
    routing_number: str = pydantic.Field(alias="routingNumber")
    account_number: str = pydantic.Field(alias="accountNumber")
    account_type: BankType = pydantic.Field(alias="accountType")
    plaid: typing.Optional[PlaidLinkRequest] = None
    check_options: typing.Optional[BankAccountCheckOptions] = pydantic.Field(alias="checkOptions", default=None)
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodRequest_Card(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["card"] = "card"
    card_type: CardType = pydantic.Field(alias="cardType")
    card_brand: CardBrand = pydantic.Field(alias="cardBrand")
    last_four: str = pydantic.Field(alias="lastFour")
    exp_month: str = pydantic.Field(alias="expMonth")
    exp_year: str = pydantic.Field(alias="expYear")
    token: str
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodRequest_Check(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["check"] = "check"
    pay_to_the_order_of: str = pydantic.Field(alias="payToTheOrderOf")
    address_line_1: str = pydantic.Field(alias="addressLine1")
    address_line_2: typing.Optional[str] = pydantic.Field(alias="addressLine2", default=None)
    city: str
    state_or_province: str = pydantic.Field(alias="stateOrProvince")
    postal_code: str = pydantic.Field(alias="postalCode")
    country: str
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodRequest_Custom(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["custom"] = "custom"
    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    account_name: typing.Optional[str] = pydantic.Field(alias="accountName", default=None)
    account_number: typing.Optional[str] = pydantic.Field(alias="accountNumber", default=None)
    available_balance: typing.Optional[float] = pydantic.Field(alias="availableBalance", default=None)
    schema_id: CustomPaymentMethodSchemaId = pydantic.Field(alias="schemaId")
    data: typing.Dict[str, str]
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodRequest_OffPlatform(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["offPlatform"] = "offPlatform"
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaymentMethodRequest_Utility(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

    PaymentMethodRequest_BankAccount(
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
    )
    """

    type: typing.Literal["utility"] = "utility"
    utility_id: str = pydantic.Field(alias="utilityId")
    default_source: typing.Optional[bool] = pydantic.Field(alias="defaultSource", default=None)
    default_destination: typing.Optional[bool] = pydantic.Field(alias="defaultDestination", default=None)
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    frozen: typing.Optional[bool] = None
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


"""
from mercoa.payment_method_types import PaymentMethodRequest_BankAccount

PaymentMethodRequest_BankAccount(
    routing_number="12345678",
    account_number="99988767623",
    account_type="CHECKING",
)
"""
PaymentMethodRequest = typing.Union[
    PaymentMethodRequest_BankAccount,
    PaymentMethodRequest_Card,
    PaymentMethodRequest_Check,
    PaymentMethodRequest_Custom,
    PaymentMethodRequest_OffPlatform,
    PaymentMethodRequest_Utility,
]
