# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .payment_method_id import PaymentMethodId
import pydantic
import typing
from .currency_code import CurrencyCode
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PaymentMethodBaseResponse(UniversalBaseModel):
    id: PaymentMethodId
    is_default_source: bool = pydantic.Field(alias="isDefaultSource")
    """
    Indicates whether this payment method is the default source for the entity
    """

    is_default_destination: bool = pydantic.Field(alias="isDefaultDestination")
    """
    Indicates whether this payment method is the default destination for the entity
    """

    supported_currencies: typing.List[CurrencyCode] = pydantic.Field(alias="supportedCurrencies")
    external_accounting_system_id: typing.Optional[str] = pydantic.Field(
        alias="externalAccountingSystemId", default=None
    )
    """
    ID for this payment method in the external accounting system (e.g Rutter or Codat)
    """

    frozen: bool = pydantic.Field()
    """
    Frozen payment methods cannot be used for payments, but will still be returned in API responses.
    """

    metadata: typing.Dict[str, str] = pydantic.Field()
    """
    Metadata associated with this payment method.
    """

    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
