# This file was auto-generated by Fern from our API Definition.

from .payment_method_base_request import PaymentMethodBaseRequest
import typing
import pydantic
from .custom_payment_method_schema_id import CustomPaymentMethodSchemaId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CustomPaymentMethodUpdateRequest(PaymentMethodBaseRequest):
    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    """
    ID for this payment method in your system
    """

    account_name: typing.Optional[str] = pydantic.Field(alias="accountName", default=None)
    account_number: typing.Optional[str] = pydantic.Field(alias="accountNumber", default=None)
    available_balance: typing.Optional[float] = pydantic.Field(alias="availableBalance", default=None)
    """
    The available balance for this payment method.
    """

    schema_id: typing.Optional[CustomPaymentMethodSchemaId] = pydantic.Field(alias="schemaId", default=None)
    """
    Payment method schema used for this payment method. Defines the fields that this payment method contains.
    """

    data: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Object of key/value pairs that matches the keys in the linked payment method schema.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
