# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .custom_payment_method_schema_field_type import CustomPaymentMethodSchemaFieldType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CustomPaymentMethodSchemaField(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.payment_method_types import CustomPaymentMethodSchemaField

    CustomPaymentMethodSchemaField(
        name="payToTheOrderOf",
        display_name="Pay To The Order Of",
        type="text",
        optional=False,
    )
    """

    name: str
    display_name: typing.Optional[str] = pydantic.Field(alias="displayName", default=None)
    type: CustomPaymentMethodSchemaFieldType
    optional: bool = pydantic.Field()
    """
    Indicates whether this field is optional
    """

    use_as_account_name: typing.Optional[bool] = pydantic.Field(alias="useAsAccountName", default=None)
    """
    Indicates whether this field should be used as the name of the payment method. Only one field can be used as the name. Will set the accountName field of the payment method to the value of this field.
    """

    use_as_account_number: typing.Optional[bool] = pydantic.Field(alias="useAsAccountNumber", default=None)
    """
    Indicates whether this field should be used as the account number of the payment method. Only one field can be used as the account number. Will set the accountNumber field of the payment method to the value of this field.
    """

    options: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    When type is 'select', provide options that can be selected
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
