# This file was auto-generated by Fern from our API Definition.

from .payment_method_base_response import PaymentMethodBaseResponse
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CheckResponse(PaymentMethodBaseResponse):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import CheckResponse

    CheckResponse(
        id="pm_5fde2f4a-facc-48ef-8f0d-6b7d087c7b18",
        pay_to_the_order_of="John Doe",
        address_line_1="123 Main St",
        address_line_2="Apt 1",
        city="New York",
        state_or_province="NY",
        postal_code="10001",
        country="US",
        is_default_source=False,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    pay_to_the_order_of: str = pydantic.Field(alias="payToTheOrderOf")
    address_line_1: str = pydantic.Field(alias="addressLine1")
    address_line_2: typing.Optional[str] = pydantic.Field(alias="addressLine2", default=None)
    city: str
    state_or_province: str = pydantic.Field(alias="stateOrProvince")
    postal_code: str = pydantic.Field(alias="postalCode")
    country: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
