# This file was auto-generated by Fern from our API Definition.

from .payment_method_base_request import PaymentMethodBaseRequest
import typing
import pydantic
from .plaid_link_request import PlaidLinkRequest
from .bank_account_check_options import BankAccountCheckOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BankAccountUpdateRequest(PaymentMethodBaseRequest):
    account_name: typing.Optional[str] = pydantic.Field(alias="accountName", default=None)
    plaid: typing.Optional[PlaidLinkRequest] = pydantic.Field(default=None)
    """
    If provided, will update a bank account using Plaid Link
    """

    check_options: typing.Optional[BankAccountCheckOptions] = pydantic.Field(alias="checkOptions", default=None)
    """
    If this bank account supports check printing, use this to enable check printing and set the check options. Checks will be printed directly from the bank account.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
