# This file was auto-generated by Fern from our API Definition.

from .payment_method_base_response import PaymentMethodBaseResponse
import pydantic
from .bank_type import BankType
from .bank_status import BankStatus
import typing
from .bank_account_check_options import BankAccountCheckOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BankAccountResponse(PaymentMethodBaseResponse):
    """
    Examples
    --------
    import datetime

    from mercoa.payment_method_types import BankAccountResponse

    BankAccountResponse(
        id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        account_name="My Checking Account",
        bank_name="Chase",
        routing_number="12345678",
        account_number="99988767623",
        account_type="CHECKING",
        status="VERIFIED",
        is_default_source=True,
        is_default_destination=True,
        supported_currencies=["USD"],
        metadata={},
        frozen=False,
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    account_name: str = pydantic.Field(alias="accountName")
    bank_name: str = pydantic.Field(alias="bankName")
    routing_number: str = pydantic.Field(alias="routingNumber")
    account_number: str = pydantic.Field(alias="accountNumber")
    account_type: BankType = pydantic.Field(alias="accountType")
    status: BankStatus
    check_options: typing.Optional[BankAccountCheckOptions] = pydantic.Field(alias="checkOptions", default=None)
    """
    If check printing is enabled for the account, will return the check options for this bank account
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
