# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BankAccountCheckOptions(UniversalBaseModel):
    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, will allow the user to print checks from this bank account
    """

    initial_check_number: typing.Optional[int] = pydantic.Field(alias="initialCheckNumber", default=None)
    """
    If provided, will start the check number sequence at the provided number. If not provided, will start at 5000.
    """

    routing_number_override: typing.Optional[str] = pydantic.Field(alias="routingNumberOverride", default=None)
    """
    If provided, will print a check with the provided routing number instead of the one from the bank account
    """

    account_number_override: typing.Optional[str] = pydantic.Field(alias="accountNumberOverride", default=None)
    """
    If provided, will print a check with the provided account number instead of the one from the bank account
    """

    signatory_name: str = pydantic.Field(alias="signatoryName")
    """
    Name of the person who's signature will be printed on the check.
    """

    signature_image: typing.Optional[str] = pydantic.Field(alias="signatureImage", default=None)
    """
    Base64 encoded image of the signature. If not provided, will use the signatoryName to generate a signature. Mercoa will automatically grayscale, resize, and convert the image to a PNG the image to fit on the check.
    """

    use_signature_image: typing.Optional[bool] = pydantic.Field(alias="useSignatureImage", default=None)
    """
    If true, will print checks with the provided signatureImage. If false, will print checks with a generated signature from the signatoryName. If this parameter is not set the default behavior is to use the signatureImage if provided.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
