# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ...entity_types.types.vendor_network import VendorNetwork
from ...entity_types.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OcrRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.ocr import OcrRequest

    OcrRequest(
        vendor_network="entity",
        entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
        mime_type="image/png",
        image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
    )
    """

    mime_type: str = pydantic.Field(alias="mimeType")
    """
    MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.
    """

    image: str = pydantic.Field()
    """
    Base64 encoded image or PDF. PNG, JPG, WEBP, and PDF are supported. 10MB max.
    """

    vendor_network: typing.Optional[VendorNetwork] = pydantic.Field(alias="vendorNetwork", default=None)
    """
    Limit OCR vendor search to a specific network
    """

    entity_id: typing.Optional[EntityId] = pydantic.Field(alias="entityId", default=None)
    """
    When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
