# This file was auto-generated by Fern from our API Definition.

from .invoice_line_item_request_base import InvoiceLineItemRequestBase
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class InvoiceLineItemUpdateRequest(InvoiceLineItemRequestBase):
    """
    Examples
    --------
    import datetime

    from mercoa.invoice_types import InvoiceLineItemUpdateRequest

    InvoiceLineItemUpdateRequest(
        id="inli_26672f38-eb9a-48f1-a7a0-f1b855e38cd7",
        amount=100.0,
        currency="USD",
        description="Product A",
        name="Product A",
        quantity=1.0,
        unit_price=100.0,
        category="EXPENSE",
        service_start_date=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        service_end_date=datetime.datetime.fromisoformat(
            "2021-01-31 00:00:00+00:00",
        ),
        metadata={"key1": "value1", "key2": "value2"},
        gl_account_id="600394",
    )
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    If provided, will overwrite line item on the invoice with this ID. If not provided, will create a new line item.
    """

    amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total amount of line item in major units. If the entered amount has more decimal places than the currency supports, trailing decimals will be truncated.
    """

    description: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
