# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from ...payment_method_types.types.currency_code import CurrencyCode
import pydantic
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class InvoiceLineItemRequestBase(UniversalBaseModel):
    currency: typing.Optional[CurrencyCode] = pydantic.Field(default=None)
    """
    Currency code for the amount. Defaults to USD.
    """

    name: typing.Optional[str] = None
    quantity: typing.Optional[float] = None
    unit_price: typing.Optional[float] = pydantic.Field(alias="unitPrice", default=None)
    """
    Unit price of the line item in major units. If the entered amount has more decimal places than the currency supports, trailing decimals will be truncated.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    Category of the line item.
    """

    service_start_date: typing.Optional[dt.datetime] = pydantic.Field(alias="serviceStartDate", default=None)
    service_end_date: typing.Optional[dt.datetime] = pydantic.Field(alias="serviceEndDate", default=None)
    metadata: typing.Optional[typing.Dict[str, str]] = None
    gl_account_id: typing.Optional[str] = pydantic.Field(alias="glAccountId", default=None)
    """
    ID of general ledger account associated with this line item.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
