# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from ...entity_types.types.entity_user_response import EntityUserResponse
from .associated_approval_action import AssociatedApprovalAction
import pydantic
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CommentResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_types import EntityUserResponse
    from mercoa.invoice_types import CommentResponse

    CommentResponse(
        id="ic_b3525b66-da94-4525-9f31-426bcf657128",
        text="This is a comment",
        user=EntityUserResponse(
            id="user_ec3aafc8-ea86-408a-a6c1-545497badbbb",
            foreign_id="MY-DB-ID-12345",
            email="john.doe@acme.com",
            name="John Doe",
            roles=["admin", "approver"],
            created_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
            updated_at=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
        ),
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    id: str
    text: str
    user: typing.Optional[EntityUserResponse] = None
    associated_approval_action: typing.Optional[AssociatedApprovalAction] = pydantic.Field(
        alias="associatedApprovalAction", default=None
    )
    """
    If an approval action has triggered the generation of this comment, returns the associated approval action and actor
    """

    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
