# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from .bank_delivery_method import BankDeliveryMethod
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BankAccountPaymentDestinationOptions(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.invoice_types import BankAccountPaymentDestinationOptions

    BankAccountPaymentDestinationOptions(
        delivery="ACH_SAME_DAY",
    )
    """

    delivery: typing.Optional[BankDeliveryMethod] = pydantic.Field(default=None)
    """
    Delivery method for ACH payments. Defaults to ACH_SAME_DAY.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    ACH Statement Description. By default, this will be 'AP' followed by the first 8 characters of the invoice ID. Must be at least 4 characters and no more than 10 characters, and follow this regex pattern ^[a-zA-Z0-9\-#.$&* ]{4,10}$
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
