# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Responsibilities(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import Responsibilities

    Responsibilities(
        is_owner=True,
        ownership_percentage=40,
    )
    """

    job_title: typing.Optional[str] = pydantic.Field(alias="jobTitle", default=None)
    is_controller: typing.Optional[bool] = pydantic.Field(alias="isController", default=None)
    """
    Indicates whether this individual has significant management responsibilities within the business
    """

    is_owner: typing.Optional[bool] = pydantic.Field(alias="isOwner", default=None)
    """
    Indicates whether this individual has an ownership stake of at least 25% in the business
    """

    ownership_percentage: typing.Optional[int] = pydantic.Field(alias="ownershipPercentage", default=None)
    """
    Percentage of ownership in the business. Must be between 0 and 100.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
