# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .representative_id import RepresentativeId
from ...commons.types.full_name import FullName
import typing
from ...commons.types.phone_number import PhoneNumber
from ...commons.types.address import Address
import pydantic
from .responsibilities import Responsibilities
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RepresentativeResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, FullName, PhoneNumber
    from mercoa.entity_types import RepresentativeResponse, Responsibilities

    RepresentativeResponse(
        id="rep_7df2974a-4069-454c-912f-7e58ebe030fb",
        name=FullName(
            first_name="John",
            middle_name="Quincy",
            last_name="Adams",
            suffix="Jr.",
        ),
        phone=PhoneNumber(
            country_code="1",
            number="4155551234",
        ),
        email="john.doe@acme.com",
        address=Address(
            address_line_1="123 Main St",
            address_line_2="Unit 1",
            city="San Francisco",
            state_or_province="CA",
            postal_code="94105",
            country="US",
        ),
        birth_date_provided=True,
        government_id_provided=True,
        responsibilities=Responsibilities(
            is_owner=True,
            ownership_percentage=40,
            is_controller=True,
        ),
        created_on=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_on=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    id: RepresentativeId
    name: FullName
    phone: typing.Optional[PhoneNumber] = None
    email: typing.Optional[str] = None
    address: Address
    birth_date_provided: bool = pydantic.Field(alias="birthDateProvided")
    government_id_provided: bool = pydantic.Field(alias="governmentIDProvided")
    responsibilities: Responsibilities
    created_on: dt.datetime = pydantic.Field(alias="createdOn")
    updated_on: dt.datetime = pydantic.Field(alias="updatedOn")
    disabled_on: typing.Optional[dt.datetime] = pydantic.Field(alias="disabledOn", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
