# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from .business_profile_request import BusinessProfileRequest
import pydantic
from .individual_profile_request import IndividualProfileRequest
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProfileRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileRequest,
        Ein,
        ProfileRequest,
        TaxId,
    )

    ProfileRequest(
        business=BusinessProfileRequest(
            email="customer@acme.com",
            legal_business_name="Acme Inc.",
            website="http://www.acme.com",
            business_type="llc",
            phone=PhoneNumber(
                country_code="1",
                number="4155551234",
            ),
            address=Address(
                address_line_1="123 Main St",
                address_line_2="Unit 1",
                city="San Francisco",
                state_or_province="CA",
                postal_code="94105",
                country="US",
            ),
            tax_id=TaxId(
                ein=Ein(
                    number="12-3456789",
                ),
            ),
        ),
    )
    """

    business: typing.Optional[BusinessProfileRequest] = pydantic.Field(default=None)
    """
    If this entity is a business, set this field
    """

    individual: typing.Optional[IndividualProfileRequest] = pydantic.Field(default=None)
    """
    If this entity is a individual, set this field
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
