# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .notification_id import NotificationId
import typing
from ...invoice_types.types.invoice_id import InvoiceId
import pydantic
from .notification_type import NotificationType
from .notification_status import NotificationStatus
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NotificationResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_types import NotificationResponse

    NotificationResponse(
        id="notif_7df2974a-4069-454c-912f-7e58ebe030fb",
        invoice_id="in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9",
        type="INVOICE_APPROVAL_NEEDED",
        status="SENT",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    id: NotificationId
    invoice_id: typing.Optional[InvoiceId] = pydantic.Field(alias="invoiceId", default=None)
    """
    The invoice ID that this notification is related to. This field is only present for notifications related to invoices.
    """

    type: NotificationType
    status: NotificationStatus
    created_at: dt.datetime = pydantic.Field(alias="createdAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
