# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .entity_user_id import EntityUserId
from .notification_type import NotificationType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NotificationPolicyResponse(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import NotificationPolicyResponse

    NotificationPolicyResponse(
        disabled=False,
        additional_roles=["admin", "approver"],
        additional_users=["user_1234"],
        type="INVOICE_APPROVAL_NEEDED",
        notify_payee_counterparty=True,
        notify_payor_counterparty=True,
    )
    """

    disabled: bool = pydantic.Field()
    """
    True if the selected notification type is disabled for this entity
    """

    additional_roles: typing.List[str] = pydantic.Field(alias="additionalRoles")
    """
    List of user roles that should receive notifications in addition to the default users for this notification type
    """

    additional_users: typing.List[EntityUserId] = pydantic.Field(alias="additionalUsers")
    """
    List of user IDs that should receive notifications in addition to the default users for this notification type
    """

    notify_payee_counterparty: bool = pydantic.Field(alias="notifyPayeeCounterparty")
    """
    True if the selected notification type should be sent to the counterparty if this is a payable invoice.
    """

    notify_payor_counterparty: bool = pydantic.Field(alias="notifyPayorCounterparty")
    """
    True if the selected notification type should be sent to the counterparty if this is a receivable invoice.
    """

    type: NotificationType

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
