# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .entity_user_id import EntityUserId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NotificationPolicyRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import NotificationPolicyRequest

    NotificationPolicyRequest(
        disabled=True,
        additional_roles=[],
    )
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Set to true if the selected notification type should be disabled for this entity
    """

    additional_roles: typing.Optional[typing.List[str]] = pydantic.Field(alias="additionalRoles", default=None)
    """
    List of user roles that should receive notifications in addition to the default users for this notification type
    """

    additional_users: typing.Optional[typing.List[EntityUserId]] = pydantic.Field(alias="additionalUsers", default=None)
    """
    List of user IDs that should receive notifications in addition to the default users for this notification type
    """

    notify_payee_counterparty: typing.Optional[bool] = pydantic.Field(alias="notifyPayeeCounterparty", default=None)
    """
    Set to true if the selected notification type should be sent to the counterparty if this is a payable invoice.
    """

    notify_payor_counterparty: typing.Optional[bool] = pydantic.Field(alias="notifyPayorCounterparty", default=None)
    """
    Set to true if the selected notification type should be sent to the counterparty if this is a receivable invoice.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
