# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .notification_response import NotificationResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class FindNotificationResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_types import FindNotificationResponse, NotificationResponse

    FindNotificationResponse(
        count=2,
        has_more=False,
        data=[
            NotificationResponse(
                id="notif_7df2974a-4069-454c-912f-7e58ebe030fb",
                invoice_id="in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9",
                type="INVOICE_APPROVAL_NEEDED",
                status="SENT",
                created_at=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
            ),
            NotificationResponse(
                id="notif_958c4ffb-dc06-494c-a0e0-1b4946c6bb0f",
                invoice_id="in_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9",
                type="INVOICE_APPROVED",
                status="SENT",
                created_at=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
            ),
        ],
    )
    """

    count: int = pydantic.Field()
    """
    Total number of notifications for the given start and end date filters. This value is not limited by the limit parameter. It is provided so that you can determine how many pages of results are available.
    """

    has_more: bool = pydantic.Field(alias="hasMore")
    """
    True if there are more notifications available for the given start and end date filters.
    """

    data: typing.List[NotificationResponse]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
