# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_user_id import EntityUserId
import typing
import pydantic
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityUserResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_types import EntityUserResponse

    EntityUserResponse(
        id="user_ec3aafc8-ea86-408a-a6c1-545497badbbb",
        foreign_id="MY-DB-ID-12345",
        email="john.doe@acme.com",
        name="John Doe",
        roles=["admin", "approver"],
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    id: EntityUserId
    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    """
    The ID used to identify this user in your system.
    """

    email: typing.Optional[str] = None
    name: typing.Optional[str] = None
    roles: typing.List[str]
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
