# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityUserRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import EntityUserRequest

    EntityUserRequest(
        foreign_id="MY-DB-ID-12345",
        email="john.doe@acme.com",
        name="John Doe",
        roles=["admin", "approver"],
    )
    """

    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    """
    The ID used to identify this user in your system.
    """

    email: typing.Optional[str] = None
    name: typing.Optional[str] = None
    roles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of roles. A role can be any string. For example: "payer", "approver", "viewer"
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
