# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_id import EntityId
import typing
import pydantic
from .account_type import AccountType
from .profile_response import ProfileResponse
from .entity_status import EntityStatus
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BusinessProfileResponse,
        Ein,
        EntityResponse,
        ProfileResponse,
        TaxId,
    )

    EntityResponse(
        id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
        foreign_id="MY-DB-ID-12345",
        name="Acme Inc.",
        email="customer@acme.com",
        accepted_tos=True,
        status="verified",
        is_customer=True,
        is_payor=True,
        is_payee=False,
        is_network_payor=False,
        is_network_payee=False,
        account_type="business",
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-02 00:00:00+00:00",
        ),
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        profile=ProfileResponse(
            business=BusinessProfileResponse(
                email="customer@acme.com",
                legal_business_name="Acme Inc.",
                business_type="llc",
                phone=PhoneNumber(
                    country_code="1",
                    number="4155551234",
                ),
                address=Address(
                    address_line_1="123 Main St",
                    address_line_2="Unit 1",
                    city="San Francisco",
                    state_or_province="CA",
                    postal_code="94105",
                    country="US",
                ),
                tax_id_provided=True,
                tax_id=TaxId(
                    ein=Ein(
                        number="12-3456789",
                    ),
                ),
                owners_provided=True,
            ),
        ),
    )
    """

    id: EntityId
    name: str
    email: str
    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    """
    The ID used to identify this entity in your system
    """

    email_to: typing.Optional[str] = pydantic.Field(alias="emailTo", default=None)
    """
    Local-part/username of the email address to which to send invoices to be added to the Invoice Inbox.
    """

    email_to_alias: typing.Optional[typing.List[str]] = pydantic.Field(alias="emailToAlias", default=None)
    """
    Email inbox alias addresses. Used when forwarding emails to the emailTo address from an alias.
    """

    is_customer: bool = pydantic.Field(alias="isCustomer")
    """
    True if this entity has a direct relationship with your organization.
    """

    account_type: AccountType = pydantic.Field(alias="accountType")
    profile: ProfileResponse
    logo: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for the entity logo
    """

    status: EntityStatus
    accepted_tos: bool = pydantic.Field(alias="acceptedTos")
    """
    True if this entity has accepted the terms of service.
    """

    is_payor: bool = pydantic.Field(alias="isPayor")
    """
    True if this entity can pay invoices.
    """

    is_payee: bool = pydantic.Field(alias="isPayee")
    """
    True if this entity can receive payments.
    """

    is_network_payor: bool = pydantic.Field(alias="isNetworkPayor")
    """
    True if this entity is available as a payor to any entity on your platform. Otherwise this entity will only be available as a payor to entities that have a direct relationship with this entity.
    """

    is_network_payee: bool = pydantic.Field(alias="isNetworkPayee")
    """
    True if this entity is available as a payee to any entity on your platform. Otherwise this entity will only be available as a payee to entities that have a direct relationship with this entity.
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Simple key/value metadata associated with this entity. For more complex metadata, use the Metadata API.
    """

    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
