# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_id import EntityId
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityCloneRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import EntityCloneRequest

    EntityCloneRequest(
        create_from_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
        foreign_id="MY-DB-ID-12345",
    )
    """

    create_from_id: EntityId = pydantic.Field(alias="createFromId")
    """
    The ID or ForeignId of the entity to clone.
    """

    foreign_id: typing.Optional[str] = pydantic.Field(alias="foreignId", default=None)
    """
    The ID used to identify this entity in your system. This ID must be unique across all entities in your system.
    """

    email_to: typing.Optional[str] = pydantic.Field(alias="emailTo", default=None)
    """
    Sets the email address to which to send invoices to be added to the Invoice Inbox. Only provide the local-part/username of the email address, do not include the @domain.com
    """

    email_to_alias: typing.Optional[typing.List[str]] = pydantic.Field(alias="emailToAlias", default=None)
    """
    Email inbox alias addresses. Used when forwarding emails to the emailTo address from an alias. Include the full email address.
    """

    logo: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base64 encoded PNG image data for the entity logo. Max size 100KB.
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Simple key/value metadata associated with this entity. For more complex metadata, use the Metadata API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
