# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .email_template_type import EmailTemplateType
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EmailTemplateRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import EmailTemplateRequest

    EmailTemplateRequest(
        template_type="PAYMENT",
        name="Generic Payment Email",
        subject="Action Required - Your payment is due",
        content="<h1>Your invoice has been sent.</h1>",
        is_default=True,
    )
    """

    template_type: EmailTemplateType = pydantic.Field(alias="templateType")
    name: str = pydantic.Field()
    """
    The name of the email template.
    """

    subject: str = pydantic.Field()
    """
    The subject of the email template.
    """

    content: str = pydantic.Field()
    """
    The HTML content of the email template.
    """

    is_default: typing.Optional[bool] = pydantic.Field(alias="isDefault", default=None)
    """
    If true, this email template will be used as the default template for new invoices.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
