# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_id import EntityId
import pydantic
import typing
from .counterparty_customization_account import CounterpartyCustomizationAccount
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CounterpartyCustomizationRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import (
        CounterpartyCustomizationAccount,
        CounterpartyCustomizationRequest,
    )

    CounterpartyCustomizationRequest(
        counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        accounts=[
            CounterpartyCustomizationAccount(
                account_id="85866843",
                postal_code="94105",
                name_on_account="John Doe",
            )
        ],
    )
    """

    counterparty_id: EntityId = pydantic.Field(alias="counterpartyId")
    accounts: typing.Optional[typing.List[CounterpartyCustomizationAccount]] = pydantic.Field(default=None)
    """
    The list of accounts the entity has with the counterparty.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
